package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author weichu
 * @time 2021/7/13 13:40
 */
@ApiModel(
        value = "Address",
        description = "地址"
)
public class Address {
    @ApiModelProperty(
            name = "id",
            hidden = true
    )
    private Long id;
    @ApiModelProperty(
            name = "contact",
            value = "联系人"
    )
    private String contact;
    @ApiModelProperty(
            name = "phone",
            value = "联系人手机号码"
    )
    private String phone;
    @ApiModelProperty(
            name = "region",
            value = "所在地区",
            required = true
    )
    private String region;
    @ApiModelProperty(
            name = "detailAddr",
            value = "详细地址",
            required = true
    )
    @NotNull(
            message = "详细地址不能为空"
    )
    private String detailAddr;
    @ApiModelProperty(
            name = "postcode",
            value = "邮编"
    )
    private String postcode;
    @ApiModelProperty(
            name = "provinceCode",
            value = "邮编码"
    )
    private String provinceCode;
    @ApiModelProperty(
            name = "cityCode",
            value = "市编码"
    )
    private String cityCode;
    @ApiModelProperty(
            name = "districtCode",
            value = "区编码"
    )
    private String districtCode;
    @ApiModelProperty(
            name = "streetCode",
            value = "街道编码"
    )
    private String streetCode;
    @ApiModelProperty(
            name = "province",
            value = "所在省名称"
    )
    private String province;
    @ApiModelProperty(
            name = "city",
            value = "所在市名称"
    )
    private String city;
    @ApiModelProperty(
            name = "district",
            value = "所在区名称"
    )
    private String district;
    @ApiModelProperty(
            name = "addressType",
            value = "地址类型：1常用地址,2收货地址,3户籍地址"
    )
    private String addressType;
    @ApiModelProperty(
            name = "status",
            value = "是否默认地址: 0 否 1 是",
            required = true
    )
    private Integer status;
    @ApiModelProperty(
            name = "userId",
            value = "用户id",
            required = true
    )
    private Long userId;
    @ApiModelProperty(
            name = "locationX",
            value = "经度X",
            required = true
    )
    private String locationX;
    @ApiModelProperty(
            name = "locationY ",
            value = "纬度Y",
            required = true
    )
    private String locationY;

    public Address() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDetailAddr() {
        return this.detailAddr;
    }

    public void setDetailAddr(String detailAddr) {
        this.detailAddr = detailAddr;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getProvinceCode() {
        return this.provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getDistrictCode() {
        return this.districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getStreetCode() {
        return this.streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getLocationX() {
        return this.locationX;
    }

    public void setLocationX(String locationX) {
        this.locationX = locationX;
    }

    public String getLocationY() {
        return this.locationY;
    }

    public void setLocationY(String locationY) {
        this.locationY = locationY;
    }
}
