/**
 * @(#)ApplyFormAudit.java 1.0 2019/9/19
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 申请单审核
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ApplyFormAudit", description = "申请单审核")
public class ApplyFormAudit implements Serializable {

    private static final long serialVersionUID = 5207094729540970051L;
    @ApiModelProperty(name = "id", value = "商户申请单id")
    private Long id;

    @Min(1)
    @Max(3)
    @ApiModelProperty(name = "status", value = "审核状态: 1 未审核；2 审核通过； 3 审核不通过 ")
    private Integer status;

    @Size(max = 255)
    @ApiModelProperty(name = "opinion", value = "审核意见")
    private String opinion;

    @ApiModelProperty(name = "auditPerson", value = "审核人")
    private String auditPerson;

    @ApiModelProperty(name = "auditTime", value = "审核时间")
    private String auditTime;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称，选填")
    private String organizationName;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getOpinion() {
        return opinion;
    }

    public void setOpinion(String opinion) {
        this.opinion = opinion;
    }

    public String getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(String auditPerson) {
        this.auditPerson = auditPerson;
    }

    public String getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(String auditTime) {
        this.auditTime = auditTime;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }
}
