package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 申请单
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ApplyFormDto", description = "申请单")
public class ApplyFormDto {

    private static final long serialVersionUID = -8204023139659723746L;

    @ApiModelProperty(name = "id", value = "申请单id", hidden = true)
    private Long id;

    /**
     * 商家
     */
    @NotNull(message = "商家信息不能为空")
    @ApiModelProperty(name = "merchant", value = "商家")
    private Merchant merchant;

    @NotNull
    @ApiModelProperty(name = "isDraft", value = "是否保存为草稿")
    private Boolean isDraft;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Merchant getMerchant() {
        return merchant;
    }

    public void setMerchant(Merchant merchant) {
        this.merchant = merchant;
    }

    public Boolean getDraft() {
        return isDraft;
    }

    public void setDraft(Boolean draft) {
        isDraft = draft;
    }
}
