/**
 * @(#)LicenseInfo.java 1.0 2019/9/16
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 证照信息
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "LicenseInfo", description = "证件信息")
public class LicenseInfo implements Serializable {

    private static final long serialVersionUID = -6910568454264128235L;

    /**
     * 执照类型： 1 多证合一营业执照;  2  普通营业执照
     */
    @NotNull
    @ApiModelProperty(name = "licenseType", value = "执照类型： 1 多证合一营业执照;  2  普通营业执照")
    private Integer licenseType;

    /**
     * 营业执照正面
     */
    @ApiModelProperty(name = " businessLicenseA", value = "营业执照正面")
    private String businessLicenseA;

    /**
     * 营业执照背面
     */
    @ApiModelProperty(name = "businessLicenseB", value = "营业执照背面")
    private String businessLicenseB;

    /**
     * 统一社会信用代码
     */
    @NotBlank
    @ApiModelProperty(name = "socialCode", value = "统一社会信用代码")
    private String socialCode;

    /**
     * 营业期限起始
     */
    @NotBlank
    @ApiModelProperty(name = "tradeTermUp", value = "营业期限起始")
    private String tradeTermUp;

    /**
     * 营业期限截止
     */
    @NotBlank
    @ApiModelProperty(name = "tradeTermEnd", value = "营业期限截止")
    private String tradeTermEnd;

    /**
     * 证件类型: 1 大陆居民身份证; 2 港台澳（身份证、居民通行证）; 3 护照（限境外人士）
     */
    @NotNull
    @ApiModelProperty(name = "cardType", value = "证件类型: 1 大陆居民身份证; 2 港台澳（身份证、居民通行证）; 3 护照（限境外人士）")
    private Integer cardType;

    /**
     * 证件有效期开始
     */
    @NotBlank
    @ApiModelProperty(name = "cardPeriodUp", value = "证件有效期开始")
    private String cardPeriodUp;

    /**
     * 证件有效期截止
     */
    @NotBlank
    @ApiModelProperty(name = "cardPeriodEnd", value = "证件有效期截止")
    private String cardPeriodEnd;

    /**
     * 证件号码
     */
    @NotBlank
    @ApiModelProperty(name = "cardNo", value = "证件号码")
    private String cardNo;

    /**
     * 证件正面
     */
    @NotBlank
    @ApiModelProperty(name = "idCardA", value = "证件正面")
    private String idCardA;

    /**
     * 证件反面
     */
    @NotBlank
    @ApiModelProperty(name = "idCardB", value = "证件反面")
    private String idCardB;

    /**
     * 法人
     */
    @NotBlank
    @Size(max = 32, message = "法人的长度必须在0和32之间")
    @ApiModelProperty(name = "manager", value = "法人")
    private String manager;


    public String getBusinessLicenseA() {
        return businessLicenseA;
    }

    public void setBusinessLicenseA(String businessLicenseA) {
        this.businessLicenseA = businessLicenseA;
    }

    public String getBusinessLicenseB() {
        return businessLicenseB;
    }

    public void setBusinessLicenseB(String businessLicenseB) {
        this.businessLicenseB = businessLicenseB;
    }

    public Integer getLicenseType() {
        return licenseType;
    }

    public void setLicenseType(Integer licenseType) {
        this.licenseType = licenseType;
    }

    public String getSocialCode() {
        return socialCode;
    }

    public void setSocialCode(String socialCode) {
        this.socialCode = socialCode;
    }

    public Integer getCardType() {
        return cardType;
    }

    public void setCardType(Integer cardType) {
        this.cardType = cardType;
    }

    public String getTradeTermUp() {
        return tradeTermUp;
    }

    public void setTradeTermUp(String tradeTermUp) {
        this.tradeTermUp = tradeTermUp;
    }

    public String getTradeTermEnd() {
        return tradeTermEnd;
    }

    public void setTradeTermEnd(String tradeTermEnd) {
        this.tradeTermEnd = tradeTermEnd;
    }

    public String getCardPeriodUp() {
        return cardPeriodUp;
    }

    public void setCardPeriodUp(String cardPeriodUp) {
        this.cardPeriodUp = cardPeriodUp;
    }

    public String getCardPeriodEnd() {
        return cardPeriodEnd;
    }

    public void setCardPeriodEnd(String cardPeriodEnd) {
        this.cardPeriodEnd = cardPeriodEnd;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getIdCardA() {
        return idCardA;
    }

    public void setIdCardA(String idCardA) {
        this.idCardA = idCardA;
    }

    public String getIdCardB() {
        return idCardB;
    }

    public void setIdCardB(String idCardB) {
        this.idCardB = idCardB;
    }

    public String getManager() {
        return manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }
}
