/**
 * @(#)Access.java 1.0 2019年7月23日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 商户
 * （1）商户基本信息
 * （2）公司信息+证照信息
 * （2）商户经营区域信息
 * （3）商户业务经营范围
 *
 * @author malu
 * @time 2019年7月23日 上午10:35:39
 */
@ApiModel(value = "Merchant", description = "商户")
public class Merchant implements Serializable {

    private static final long serialVersionUID = -5893713692065134532L;

    //（1）商户基本信息
    /**
     * 商户id
     */
    @ApiModelProperty(name = "id", value = "商户id")
    private Long id;

    @ApiModelProperty(name = "employeeId", value = "员工id")
    private Long employeeId;

    /**
     * 商户编码
     */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    /**
     * 商户类型
     */
    @NotBlank
    @ApiModelProperty(name = "type", value = "商户类型（PERSONAL 个人 INDIVIDUAL 个体工商户 ENTERPRISE 企业）")
    private String type;

    @ApiModelProperty(name = "distributorType", value = "2加价分销，1佣金分销")
    private Integer distributorType;

    /**
     * 商户名称
     */
    @NotBlank
    @ApiModelProperty(name = "name", value = "商户名称")
    private String name;

    /**
     * 入驻时间，与审核通过的auditTime 一致
     */
    @ApiModelProperty(name = "入驻时间", value = "effectTime")
    private Date effectTime;

    /**
     * 联系人
     */
    @NotBlank
    @Size(max = 32, message = "联系人的长度必须在0和32之间")
    @ApiModelProperty(name = "contactPerson", value = "联系人")
    private String contactPerson;

    /**
     * 移动电话
     */
    @NotBlank
    @ApiModelProperty(name = "contactMobile", value = "移动电话")
    private String contactMobile;

    /**
     * 固话
     */
    @NotBlank
    @ApiModelProperty(name = "contactPhone", value = "固话")
    private String contactPhone;

    /**
     * 商户状态 (PENDING待审核 NORMAL正常 BANNED封禁 CORRECTION审核不通过)
     */
    @ApiModelProperty(name = "status", value = "商户状态")
    private String status;

    /**
     * 所有人ID
     */
    @ApiModelProperty(name = "ownerId", value = "所有人ID")
    private Long ownerId;

    /**
     * 常用邮箱
     */
    @NotBlank
    @ApiModelProperty(name = "email", value = "常用邮箱")
    private String email;

    /**
     * 客服电话
     */
    @ApiModelProperty(name = "serviceTel", value = "客服电话")
    private String serviceTel;

//  （2）公司信息+证照信息
    /**
     * 公司名称
     */
    @NotBlank
    @ApiModelProperty(name = "companyName", value = "公司名称")
    private String companyName;

    /**
     * 公司地址
     */
    @NotBlank
    @ApiModelProperty(name = "address", value = "地址")
    private String address;

    /**
     * 公司网站
     */
    @ApiModelProperty(name = "website", value = "公司网站")
    private String website;

    /**
     * 证照信息
     */
    @Valid
    @ApiModelProperty(name = "licenseInfo", value = "证照信息")
    private LicenseInfo licenseInfo;

    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "组ID")
    private Long groupId;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称，选填")
    private String organizationName;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "roleCode", value = "角色编码，选填，默认商户角色")
    private String roleCode;

    /**
     * 账号
     */
    @ApiModelProperty(name = "account", value = "账号")
    private String account;


    //（3）商户经营区域信息
    @ApiModelProperty(name = "bizAreaList", value = "商户经营区域信息")
    private List<MerchantBizScope> bizAreaList;

    //（4）商户业务经营范围
    @Size(max = 5, message = "bizBrandList（商户经营品牌）上限不超过5个")
    @ApiModelProperty(name = "bizBrandList", value = "商户经营品牌")
    private List<MerchantBizScope> bizBrandList;

    @Size(max = 1, message = "bizCategoryList（商户主营类目）上限不超过1个")
    @ApiModelProperty(name = "bizCategoryList", value = "商户经营类目")
    private List<MerchantBizScope> bizCategoryList;

    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getEffectTime() {
        return effectTime;
    }

    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactMobile() {
        return contactMobile;
    }

    public void setContactMobile(String contactMobile) {
        this.contactMobile = contactMobile;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public List<MerchantBizScope> getBizAreaList() {
        return bizAreaList;
    }

    public void setBizAreaList(List<MerchantBizScope> bizAreaList) {
        this.bizAreaList = bizAreaList;
    }

    public List<MerchantBizScope> getBizBrandList() {
        return bizBrandList;
    }

    public void setBizBrandList(List<MerchantBizScope> bizBrandList) {
        this.bizBrandList = bizBrandList;
    }

    public List<MerchantBizScope> getBizCategoryList() {
        return bizCategoryList;
    }

    public void setBizCategoryList(List<MerchantBizScope> bizCategoryList) {
        this.bizCategoryList = bizCategoryList;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getServiceTel() {
        return serviceTel;
    }

    public void setServiceTel(String serviceTel) {
        this.serviceTel = serviceTel;
    }

    public String getWebsite() {
        return website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public LicenseInfo getLicenseInfo() {
        return licenseInfo;
    }

    public void setLicenseInfo(LicenseInfo licenseInfo) {
        this.licenseInfo = licenseInfo;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Integer getDistributorType() {
        return distributorType;
    }

    public void setDistributorType(Integer distributorType) {
        this.distributorType = distributorType;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
}

