package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel(value = "MerchantBizScope", description = "商户经营范围")
public class MerchantBizScope implements Serializable {

    private static final long serialVersionUID = 3676976111556521876L;
    /**
     * Id
     */
    @ApiModelProperty(name = "Id", value = "Id")
    @NotNull
    private Long Id;

    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID")
    @NotNull
    private Long sellerId;

    /**
     * 业务类型，区分类目(CATEGORY)，品牌(BRAND)，渠道(CHANNEL)，区域（AREA）
     */
    @ApiModelProperty(name = "businessType", value = "业务类型，区分类目(CATEGORY)，品牌(BRAND)，渠道(CHANNEL)，区域（AREA）")
    @NotNull
    private String businessType;

    /**
     * 业务ID
     */
    @ApiModelProperty(name = "businessId", value = "业务ID")
    @NotNull
    private Long businessId;

    public Long getId() {
        return Id;
    }

    public void setId(Long id) {
        Id = id;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }


}
