/**
 * @(#)MerchantInfo.java 1.0 2019/10/11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 商家信息
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "MerchantInfo", description = "商家信息")
public class MerchantInfo implements Serializable {

    private static final long serialVersionUID = -5651845097773470710L;
    /**
     * 商家
     */
    @Valid
    @NotNull(message = "商家数据不能为空")
    @ApiModelProperty(name = "merchant", value = "商家")
    private Merchant merchant;

    /**
     * 账号信息
     */
    @ApiModelProperty(name = "user", value = "账号信息")
    private User user;

    public Merchant getMerchant() {
        return merchant;
    }

    public void setMerchant(Merchant merchant) {
        this.merchant = merchant;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

}
