package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.format.annotation.DateTimeFormat.ISO;

import javax.validation.constraints.Pattern;
import java.util.Date;

/**
 * @author weichu
 * @time 2021/7/13 13:38
 */
@ApiModel(
        value = "PersonalInfo",
        description = "个人信息"
)
public class PersonalInfo {
    @ApiModelProperty(
            name = "id",
            value = "id",
            hidden = true
    )
    private Long id;
    @DateTimeFormat(
            iso = ISO.DATE
    )
    @ApiModelProperty(
            name = "birthday",
            value = "生日",
            allowEmptyValue = true
    )
    private Date birthday;
    @ApiModelProperty(
            name = "province",
            value = "省份",
            allowEmptyValue = true
    )
    private String province;
    @ApiModelProperty(
            name = "city",
            value = "城市",
            allowEmptyValue = true
    )
    private String city;
    @ApiModelProperty(
            name = "district",
            value = "区/县",
            allowEmptyValue = true
    )
    private String district;
    @ApiModelProperty(
            name = "company",
            value = "工作单位",
            allowEmptyValue = true
    )
    private String company;
    @ApiModelProperty(
            name = "position",
            value = "职位",
            allowEmptyValue = true
    )
    private String position;
    @ApiModelProperty(
            name = "address",
            value = "详细地址",
            allowEmptyValue = true
    )
    private String address;
    @ApiModelProperty(
            name = "sex",
            value = "性别"
    )
    private String sex;
    @ApiModelProperty(
            name = "maritalStatus",
            value = "婚姻状态：0未婚，1已婚"
    )
    private Integer maritalStatus;
    @ApiModelProperty(
            name = "educationLevel",
            value = "教育水平:0小学，1初中，2高中，3专科，4本科，5硕士，6博士"
    )
    private Integer educationLevel;
    @ApiModelProperty(
            name = "industry",
            value = "所在行业"
    )
    private String industry;
    @Pattern(
            regexp = "(^\\d{18}$)|(^\\d{15}$)",
            message = "身份证号码格式不正确"
    )
    @ApiModelProperty(
            name = "identityCard",
            value = "身份证号码"
    )
    private String identityCard;
    @ApiModelProperty(
            name = "realName",
            value = "真实姓名"
    )
    private String realName;
    @ApiModelProperty(
            name = "avatar",
            value = "头像URL",
            allowEmptyValue = true
    )
    private String avatar;
    @ApiModelProperty(
            name = "userId",
            value = "所属用户Id",
            required = true
    )
    private Long userId;
    @ApiModelProperty(
            name = "postcode",
            value = "邮政编码",
            allowEmptyValue = true
    )
    private String postcode;
    @ApiModelProperty(
            name = "phone",
            value = "手机号码",
            allowEmptyValue = true
    )
    private String phone;
    @ApiModelProperty(
            name = "tel",
            value = "座机",
            allowEmptyValue = true
    )
    private String tel;

    public PersonalInfo() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public Integer getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(Integer maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public Integer getEducationLevel() {
        return this.educationLevel;
    }

    public void setEducationLevel(Integer educationLevel) {
        this.educationLevel = educationLevel;
    }

    public String getIndustry() {
        return this.industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public String getIdentityCard() {
        return this.identityCard;
    }

    public void setIdentityCard(String identityCard) {
        this.identityCard = identityCard;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getTel() {
        return this.tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }
}
