package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author weichu
 * @time 2021/7/13 13:41
 */
@ApiModel(
        value = "Role",
        description = "角色"
)
public class Role {
    @ApiModelProperty(
            hidden = true
    )
    private Long id;
    @ApiModelProperty("角色编号，不传则系统默认生成")
    private String code;
    @ApiModelProperty("角色名称")
    @NotNull
    private String name;
    @ApiModelProperty(
            name = "状态：1启用2禁用"
    )
    private Integer status;
    @ApiModelProperty("角色描述")
    private String description;
    @ApiModelProperty(
            name = "createPerson",
            value = "创建人",
            hidden = true
    )
    private String createPerson;
    @ApiModelProperty(
            name = "createTime",
            value = "创建时间",
            hidden = true
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createTime;
    @ApiModelProperty(
            name = "权限列表"
    )
    private List<Access> accessList = new ArrayList();

    public Role() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Access> getAccessList() {
        return this.accessList;
    }

    public void setAccessList(List<Access> accessList) {
        this.accessList = accessList;
    }

    public String getCreatePerson() {
        return this.createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
