/**
 * @(#)Access.java 1.0 2019年7月23日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import com.dtyunxi.yundt.cube.center.shop.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopAddressRespDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 店铺
 *
 * @author malu
 * @time 2019年7月23日 上午10:35:39
 */
@ApiModel(value = "Shop", description = "店铺")
public class Shop implements Serializable {

    private static final long serialVersionUID = 1556981145786977968L;

    /**
     * 店铺id
     */
    @ApiModelProperty(name = "id", value = "店铺id, 修改店铺时必传")
    private Long id;

    /**
     * 店铺id
     */
    @ApiModelProperty(name = "userId", value = "用户id")
    private Long userId;
    @ApiModelProperty(name = "employeeId", value = "员工id")
    private Long employeeId;
    /**
     * 店铺名称
     */
    @NotNull
    @ApiModelProperty(name = "name", value = "店铺名称")
    private String name;

    /**
     * 店铺编码
     */
    @ApiModelProperty(name = "code", value = "店铺编码")
    private String code;

    /**
     * 联系人
     */
    @ApiModelProperty(name = "contactPerson", value = "联系人", hidden = true)
    private String contactPerson;

    /**
     * 联系电话
     */
    @ApiModelProperty(name = "contactPhone", value = "联系电话", hidden = true)
    private String contactPhone;

    /**
     * 组织code
     */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     * 所属组织id集合，用于树状回显
     */
    @ApiModelProperty(name = "organizationIds", value = "所属组织Id集合")
    private List<Long> organizationIds;

    /**
     * 客服电话
     */
    @ApiModelProperty(name = "serviceTel", value = "客服电话")
    private String serviceTel;

    /**
     * 店铺等级
     */
    @ApiModelProperty(name = "level", value = "店铺等级")
    private Integer level;

    /**
     * 店铺logo
     */
    @ApiModelProperty(name = "logo", value = "店铺logo")
    private String logo;

    /**
     * 商户id
     */
    @NotNull(message = "所属商户不能为空")
    @ApiModelProperty(name = "sellerId", value = "商户id")
    private Long sellerId;

    /**
     * 商户名称
     */
    @ApiModelProperty(name = "sellerName", value = "商户名称")
    private String sellerName;

    /**
     * 店铺简介
     */
    @ApiModelProperty(name = "shopIntroduction", value = "店铺简介")
    private String shopIntroduction;

    /**
     * 店铺url
     */
    @ApiModelProperty(name = "shopUrl", value = "店铺url")
    private String shopUrl;

    /**
     * 发布渠道
     */
    @ApiModelProperty(name = "channel", value = "发布渠道")
    private String channel;

    /**
     * 状态：PENDING：待审核 NORMAL正常 BANNED封禁 CORRECTION审核不通过
     */
    @ApiModelProperty(name = "status", value = "状态：PENDING：待审核 NORMAL正常 BANNED封禁 CORRECTION审核不通过")
    private String status;

    /**
     * 店铺类型：1 线上业务, 2 O2O业务
     */
    @ApiModelProperty(name = "type", value = "店铺类型：1 线上业务, 2 O2O业务")
    private Long type;

    @ApiModelProperty(name = "shopFreightType", value = "运费模板类型:1店铺统一，2按类目统一，3商品自定义")
    private Integer shopFreightType;

    @ApiModelProperty(name = "manageType", value = "运营类型：1-直营；2- 加盟")
    private Integer manageType;


    @ApiModelProperty(name = "shopDirFreightDtoList", value = "按类目统一的类目运费关联list")
    private List<ShopDirFreightDto> shopDirFreightDtoList;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型: 1 快递 , 2 O2O(同城配送/到店自提)", required = true)
    private Integer businessType;

    /**
     * 营业形态：暂无（给项目组使用，由项目组确定）
     */
    @ApiModelProperty(name = "businessForm", value = "营业形态：暂无（给项目组使用，由项目组确定）")
    private Integer businessForm;

    @ApiModelProperty(name = "cityDelivery", value = "是否开启同城配送")
    private Boolean cityDelivery;

    @ApiModelProperty(name = "selfPickUp", value = "是否开启自提")
    private Boolean selfPickUp;

    @ApiModelProperty(name = "autoReceive", value = "是否开启自动接单")
    private Boolean autoReceive;

    @ApiModelProperty(name = "brandList", value = "经营品牌", hidden = true)
    private List brandList;

    @ApiModelProperty(name = "categoryList", value = "主营类目", hidden = true)
    private List categoryList;

    /**
     * 店铺业务运营范围
     */
    @ApiModelProperty(name = "bizScopeList", value = "店铺业务运营范围")
    private List<ShopBizScope> bizScopeList;

    /**
     * 店铺地址列表
     */
    @ApiModelProperty(name = "shopAddressList", value = "店铺地址列表(包含店铺退货地址)")
    private List<ShopAddressRespDto> shopAddressList;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    /**
     * 更新时间
     */
    @ApiModelProperty(name = "updateTime", value = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**
     * 扩展信息
     */
    @ApiModelProperty(name = "extension", value = "扩展信息")
    private String extension;

    @ApiModelProperty(name = "shopAreaDtoList", value = "店铺经营区域")
    private List<ShopAreaDto> shopAreaDtoList;

    @ApiModelProperty(name = "shopArea", value = "店铺经营区域")
    private String shopArea;

    @ApiModelProperty(name = "opinion", value = "审核意见")
    private String opinion;

    @ApiModelProperty(name = "isFreightFirst", value = "是否店铺优先:0否1是")
    private Integer isFreightFirst;
    @ApiModelProperty(name = "freightCountRule", value = "运费计算规则:1最大值 2 叠加计算")
    private Integer freightCountRule;
    @ApiModelProperty(name = "freightTemplateId", value = "运费模板id")
    private Long freightTemplateId;
    @ApiModelProperty(name = "freightTemplateName", value = "运费模板名称")
    private String freightTemplateName;

    @ApiModelProperty(name = "deliveryAreaDtoList", value = "线上店铺配送区域")
    private List<DeliveryAreaDto> deliveryAreaDtoList;

    @ApiModelProperty(name = "freightCountType", value = "运费计算规则: 0 最大值 1 叠加计算")
    private Integer freightCountType;

    @ApiModelProperty(name = "freightMailType", value = "运费包邮类型: 0 其中一个SKU满足包邮条件, 1 所有SKU满足包邮条件")
    private Integer freightMailType;

    @ApiModelProperty(name = "shopDeliveryDto", value = "O2O店铺配置信息")
    private ShopDeliveryDto shopDeliveryDto;

    @ApiModelProperty(name = "transportPartnerDtoList", value = "配送方信息")
    private List<ShopTransportPartnerDto> transportPartnerDtoList;

    @ApiModelProperty(name = "initShop", value = "是否是初始化数据，默认否")
    private Boolean initShop = false;

    @ApiModelProperty(name = "channelCode", value = "渠道code")
    private String channelCode;

    @ApiModelProperty(name = "auth_status", value = "授权状态")
    private Integer authStatus;

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public List<ShopAddressRespDto> getShopAddressList() {
        return shopAddressList;
    }

    public void setShopAddressList(List<ShopAddressRespDto> shopAddressList) {
        this.shopAddressList = shopAddressList;
    }

    public Integer getFreightCountRule() {
        return freightCountRule;
    }

    public void setFreightCountRule(Integer freightCountRule) {
        this.freightCountRule = freightCountRule;
    }

    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public String getFreightTemplateName() {
        return freightTemplateName;
    }

    public void setFreightTemplateName(String freightTemplateName) {
        this.freightTemplateName = freightTemplateName;
    }

    public List<DeliveryAreaDto> getDeliveryAreaDtoList() {
        return deliveryAreaDtoList;
    }

    public void setDeliveryAreaDtoList(List<DeliveryAreaDto> deliveryAreaDtoList) {
        this.deliveryAreaDtoList = deliveryAreaDtoList;
    }

    public Integer getFreightCountType() {
        return freightCountType;
    }

    public void setFreightCountType(Integer freightCountType) {
        this.freightCountType = freightCountType;
    }

    public Integer getFreightMailType() {
        return freightMailType;
    }

    public void setFreightMailType(Integer freightMailType) {
        this.freightMailType = freightMailType;
    }

    public Integer getIsFreightFirst() {
        return isFreightFirst;
    }

    public void setIsFreightFirst(Integer isFreightFirst) {
        this.isFreightFirst = isFreightFirst;
    }


    public ShopDeliveryDto getShopDeliveryDto() {
        return shopDeliveryDto;
    }

    public void setShopDeliveryDto(ShopDeliveryDto shopDeliveryDto) {
        this.shopDeliveryDto = shopDeliveryDto;
    }

    public List<ShopTransportPartnerDto> getTransportPartnerDtoList() {
        return transportPartnerDtoList;
    }

    public void setTransportPartnerDtoList(List<ShopTransportPartnerDto> transportPartnerDtoList) {
        this.transportPartnerDtoList = transportPartnerDtoList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getShopIntroduction() {
        return shopIntroduction;
    }

    public void setShopIntroduction(String shopIntroduction) {
        this.shopIntroduction = shopIntroduction;
    }

    public String getShopUrl() {
        return shopUrl;
    }

    public void setShopUrl(String shopUrl) {
        this.shopUrl = shopUrl;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getType() {
        return type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public Integer getManageType() {
        return manageType;
    }

    public void setManageType(Integer manageType) {
        this.manageType = manageType;
    }

    public Integer getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    public Integer getBusinessForm() {
        return businessForm;
    }

    public void setBusinessForm(Integer businessForm) {
        this.businessForm = businessForm;
    }

    public List<ShopBizScope> getBizScopeList() {
        return bizScopeList;
    }

    public void setBizScopeList(List<ShopBizScope> bizScopeList) {
        this.bizScopeList = bizScopeList;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }


    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getServiceTel() {
        return serviceTel;
    }

    public void setServiceTel(String serviceTel) {
        this.serviceTel = serviceTel;
    }


    public List getBrandList() {
        return brandList;
    }

    public void setBrandList(List brandList) {
        this.brandList = brandList;
    }

    public List getCategoryList() {
        return categoryList;
    }

    public void setCategoryList(List categoryList) {
        this.categoryList = categoryList;
    }

    public List<ShopAreaDto> getShopAreaDtoList() {
        return shopAreaDtoList;
    }

    public void setShopAreaDtoList(List<ShopAreaDto> shopAreaDtoList) {
        this.shopAreaDtoList = shopAreaDtoList;
    }

    public String getShopArea() {
        return shopArea;
    }

    public void setShopArea(String shopArea) {
        this.shopArea = shopArea;
    }

    public String getOpinion() {
        return opinion;
    }

    public void setOpinion(String opinion) {
        this.opinion = opinion;
    }


    public Boolean getCityDelivery() {
        return cityDelivery;
    }

    public void setCityDelivery(Boolean cityDelivery) {
        this.cityDelivery = cityDelivery;
    }

    public Boolean getSelfPickUp() {
        return selfPickUp;
    }

    public void setSelfPickUp(Boolean selfPickUp) {
        this.selfPickUp = selfPickUp;
    }

    public Boolean getAutoReceive() {
        return autoReceive;
    }

    public void setAutoReceive(Boolean autoReceive) {
        this.autoReceive = autoReceive;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public List<Long> getOrganizationIds() {
        return organizationIds;
    }

    public void setOrganizationIds(List<Long> organizationIds) {
        this.organizationIds = organizationIds;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getInitShop() {
        return initShop;
    }

    public void setInitShop(Boolean initShop) {
        this.initShop = initShop;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Integer getShopFreightType() {
        return shopFreightType;
    }

    public void setShopFreightType(Integer shopFreightType) {
        this.shopFreightType = shopFreightType;
    }

    public List<ShopDirFreightDto> getShopDirFreightDtoList() {
        return shopDirFreightDtoList;
    }

    public void setShopDirFreightDtoList(List<ShopDirFreightDto> shopDirFreightDtoList) {
        this.shopDirFreightDtoList = shopDirFreightDtoList;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Integer getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }
}
