/**
 * @(#)ShopAudit.java 1.0 2019/9/25
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 店铺审核
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ShopAudit", description = "店铺审核")
public class ShopAudit implements Serializable {
    private static final long serialVersionUID = 1723451664982422341L;

    @NotNull
    @ApiModelProperty(name = "id", value = "店铺id")
    private Long id;

    @Min(1)
    @Max(2)
    @ApiModelProperty(name = "status", value = "审核状态: 1 审核通过； 2 审核不通过")
    private Integer status;

    @Size(max = 255)
    @ApiModelProperty(name = "opinion", value = "审核意见")
    private String opinion;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getOpinion() {
        return opinion;
    }

    public void setOpinion(String opinion) {
        this.opinion = opinion;
    }

}
