/**
 * @(#)ShopBizScope.java 1.0 2019/9/24
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 店铺经营范围
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ShopBizScope", description = "店铺经营范围")
public class ShopBizScope implements Serializable {
    private static final long serialVersionUID = -4781150793519953552L;

    /**
     * Id
     */
    @ApiModelProperty(name = "Id", value = "Id")
    @NotNull
    private Long Id;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    @NotNull
    private Long shopId;

    /**
     * 业务类型，区分类目(CATEGORY)，品牌(BRAND)，渠道(CHANNEL)
     */
    @ApiModelProperty(name = "businessType", value = "业务类型，区分类目(CATEGORY)，品牌(BRAND)，渠道(CHANNEL)")
    @NotNull
    private String businessType;

    /**
     * 业务ID，类目，品牌，渠道等ID
     */
    @ApiModelProperty(name = "businessId", value = "业务ID，类目，品牌，渠道等ID")
    @NotNull
    private Long businessId;


    public Long getId() {
        return Id;
    }

    public void setId(Long id) {
        Id = id;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }
}
