package com.dtyunxi.yundt.cube.center.shop.api.agg.bo;

import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Email;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @author weichu
 * @time 2021/7/13 11:39
 */
public class User {
    private Long id;
    @ApiModelProperty(
            name = "userName",
            value = "用户名"
    )
    private String userName;
    @ApiModelProperty(
            name = "password",
            value = "密码"
    )
    private String password;
    @ApiModelProperty(
            name = "email",
            value = "邮箱"
    )
    @Email
    private String email;
    @ApiModelProperty(
            name = "phone",
            value = "手机"
    )
    private String phone;
    @ApiModelProperty(
            name = "userType",
            value = "用户分类:  1 运营用户；  2  商户方；  3  C 端用户"
    )
    private Integer userType;
    @ApiModelProperty(
            name = "channelCode",
            value = "渠道编码"
    )
    private String channelCode;
    @ApiModelProperty(
            name = "nickName",
            value = "昵称"
    )
    private String nickName;
    @ApiModelProperty(
            name = "avatar",
            value = "头像"
    )
    private String avatar;
    @ApiModelProperty(
            name = "registerTime",
            value = "注册时间"
    )
    private Date registerTime;
    @ApiModelProperty(
            name = "createPerson",
            value = "创建人"
    )
    private String createPerson;
    @ApiModelProperty(
            name = "status",
            value = "状态：1启用2禁用"
    )
    private Integer status;
    @ApiModelProperty(
            name = "personalInfo",
            value = "个人信息"
    )
    private PersonalInfo personalInfo;
    @ApiModelProperty(
            name = "addressList",
            value = "用户地址"
    )
    private List<Address> addressList;
    @ApiModelProperty(
            name = "roleSet",
            value = "角色列表"
    )
    private Set<Role> roleSet = Sets.newHashSet();
    @ApiModelProperty(
            name = "brief",
            value = "介绍"
    )
    private String brief;

    public User() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getUserType() {
        return this.userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Date getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<Address> getAddressList() {
        return this.addressList;
    }

    public void setAddressList(List<Address> addressList) {
        this.addressList = addressList;
    }

    public PersonalInfo getPersonalInfo() {
        return this.personalInfo;
    }

    public void setPersonalInfo(PersonalInfo personalInfo) {
        this.personalInfo = personalInfo;
    }

    public Set<Role> getRoleSet() {
        return this.roleSet;
    }

    public void setRoleSet(Set<Role> roleSet) {
        this.roleSet = roleSet;
    }

    public String getCreatePerson() {
        return this.createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getBrief() {
        return this.brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }
}
