/**
 * @(#)MerchantConstant.java 1.0 2019/9/11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.constant;

/**
 * @author 伊泽
 * @since 1.0.0
 */
public class MerchantConstant {

    //      状态常量： PENDING待审核 NORMAL正常 BANNED封禁  CORRECTION审核不通过  DRAFT 草稿
    public final static String STATUS_PENDING = "PENDING";
    public final static String STATUS_ENABLE = "NORMAL";
    public final static String STATUS_DISABLE = "BANNED";
    public final static String STATUS_CORRECTION = "CORRECTION";
    public final static String STATUS_DRAFT = "DRAFT";


    //       角色编码常量
    public final static String MERCHANT_ROLE_CODE = "merchant";
    // 分销员角色编码
    public final static String DISTRIBUTOR_ROLE_CODE = "distributor";

    //    商户经营业务类型常量
    public final static String CATEGORY = "CATEGORY";  //类目
    public final static String BRAND = "BRAND";   //品牌
    public final static String CHANNEL = "CHANNEL";  //渠道

    //    审核结果常量
    public final static Integer UN_AUDIT = 1;     //待审核
    public final static Integer AUDIT_PASS = 2;   //审核通过
    public final static Integer AUDIT_REJECT = 3; //审核不通过

    //    自营商户标识（对应groupId）
    public final static Long SELF_MERCHANT_FLAG = 1L;

    /**
     * 短信通知常量
     */
    //    新增商户成功-短信模板编码
    public final static String MERCHANT_ADD_TEMPLATE_CODE = "ApplyMerchant_001";
    //    新增商户成功-短信模板参数
    public final static String MERCHANT_SMS_TEMPLATE_PARAM = "password";
    //    商户入驻成功-短信模板编码
    public final static String MERCHANT_SUCCESS_TEMPLATE_CODE = "ApplyMerchant_002";
    //    商户入驻失败-短信模板编码
    public final static String MERCHANT_FAIL_TEMPLATE_CODE = "ApplyMerchant_003";

    //    店铺入驻成功-短信模板编码
    public final static String SHOP_SUCCESS_TEMPLATE_CODE = "ApplyShop_001";
    //    店铺入驻成功-短信模板参数
    public final static String SHOP_SMS_TEMPLATE_PARAM = "name";
    //    店铺入驻失败-短信模板编码
    public final static String SHOP_FAIL_TEMPLATE_CODE = "ApplyShop_002";

    //    商户入驻/开通店铺 失败-短信模板参数
    public final static String SMS_FAIL_TEMPLATE_PARAM = "reason";

    //    新增城市经理成功-短信模板编码
    public final static String CITY_MGMT_ADD_TEMPLATE_CODE = "ApplyCityer_001";
    //    新增城市经理成功-短信模板参数1(城市)
    public final static String CITY_MGMT_SMS_TEMPLATE_PARAM1 = "station";
    //    新增城市经理成功-短信模板参数2(密码)
    public final static String CITY_MGMT_SMS_TEMPLATE_PARAM2 = "pwd";

}