/**
 * @(#)ShopConstant.java 1.0 2019/9/25
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.constant;

/**
 * 店铺常量
 *
 * @author 伊泽
 * @since 1.0.0
 */
public class ShopConstant {

    /**
     * 店铺配置分组
     */
    public static final String CONFIG_GROUP_SHOP = "shop";

    /**
     * 商户可创建的最大店铺数量，默认为3
     */
    public static final String SHOP_MAX_NUM = "com.dtyunxi.yundt.module.shop.shopMaxNum";

    /**
     * 小程序登录主页展示 platform：商城主页 shop：店铺主页 默认为 platform
     */
    public static final String MAIN_PAGE_MODE = "com.dtyunxi.yundt.module.shop.mainPageMode";

    /**
     * 客服展示 shopServicer：店铺客服 platformServicer：商城客服 默认为 shopServicer
     */
    public static final String SERVICER_MODE = "com.dtyunxi.yundt.module.shop.servicerType";

    //   状态常量： PENDING：待审核 NORMAL正常 BANNED封禁 CORRECTION审核不通过
    public final static String STATUS_PENDING = "PENDING";
    public final static String STATUS_ENABLE = "NORMAL";
    public final static String STATUS_DISABLE = "BANNED";
    public final static String STATUS_CORRECTION = "CORRECTION";


    //    审核状态: 1 审核通过； 2 审核不通过
    public final static Integer AUDIT_PASS = 1;
    public final static Integer AUDIT_REJECT = 2;

    public final static String AUDIT = "PASS";
    public final static String REFUSE = "REFUSE";

    //    店铺入驻类型： 1 自营；2 POP店; 3-直营门店
    public final static Long SELF_SHOP = 1L;
    public final static Long POP_SHOP = 2L;
    public final static Long STORE_SHOP = 3L;

}
