/**
 * @(#)ShopReqDto.java 1.0 2019/9/25
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 店铺查询Dto
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ShopAggQueryDto", description = "店铺查询Dto")
public class ShopAggQueryDto {

    @ApiModelProperty(value = "商家名称")
    private String sellerName;

    @ApiModelProperty(value = "店铺名称")
    private String shopName;

    @ApiModelProperty(value = "状态：PENDING：待审核 NORMAL正常 BANNED封禁 CORRECTION审核不通过")
    private String status;

    @ApiModelProperty(value = "店铺入驻类型：1 自营；2 POP店")
    private Long type;

    @ApiModelProperty(value = "商户id")
    private Long sellerId;

    @ApiModelProperty(value = "渠道编码")
    private String channelCode;

    @ApiModelProperty( value = "店铺ID")
    private Long id;

    @ApiModelProperty(value = "所属组织")
    private String organizationName;

    @ApiModelProperty(value = "所属组织code")
    private String organizationCode;

    @ApiModelProperty( value = "联系电话")
    private String contactPhone;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getType() {
        return type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }
}
