/*
 * @(#)SubStationQueryReqDto.java 1.0 2020-06-01
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 子站查询Dto
 *
 * @author 东海
 * @since 1.0.0
 */
@ApiModel(value = "SubStationQueryReqDto", description = "子站查询Dto")
public class SubStationQueryReqDto {

    @ApiModelProperty(name = "name", value = "名称")
    private String name;

    @ApiModelProperty(name = "type", value = "类型：1 自营；2 POP店")
    private String type;

    @ApiModelProperty(name = "status", value = "状态(0启用 ， 1 禁用)")
    private Integer status;
    /**
     * 地址
     */
    @ApiModelProperty(name = "address", value = "地址")
    private String address;

    /**
     * 省份编码
     */
    @ApiModelProperty(name = "provinceCode", value = "省份编码")
    private String provinceCode;

    /**
     * 地市编码
     */
    @ApiModelProperty(name = "cityCode", value = "地市编码")
    private String cityCode;

    /**
     * 区编码
     */
    @ApiModelProperty(name = "countyCode", value = "区编码")
    private String countyCode;

    /**
     * 街道编码
     */
    @ApiModelProperty(name = "streetCode", value = "街道编码")
    private String streetCode;

    /**
     * 地理坐标。x，y
     */
    @ApiModelProperty(name = "geo", value = "地理坐标。x，y")
    private String geo;

    /**
     * 简介
     */
    @ApiModelProperty(name = "shopIntroduction", value = "简介")
    private String shopIntroduction;

    /**
     * 头像logo
     */
    @ApiModelProperty(name = "logo", value = "头像logo")
    private String logo;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public String getShopIntroduction() {
        return shopIntroduction;
    }

    public void setShopIntroduction(String shopIntroduction) {
        this.shopIntroduction = shopIntroduction;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }
}
