/**
 * @(#)ApplyFormRespDto.java 1.0 2019/9/27
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.agg.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ApplyFormRespDto", description = "申请单返回对象")
public class ApplyFormRespDto {

    //    基本信息

    /**
     * 申请单id
     */
    @ApiModelProperty(name = "id", value = "申请单id")
    private Long id;

    /**
     * 商户名称
     */
    @ApiModelProperty(name = "name", value = "商户名称")
    private String name;

    /**
     * 联系人
     */
    @ApiModelProperty(name = "contactPerson", value = "联系人")
    private String contactPerson;

    /**
     * 移动电话
     */
    @ApiModelProperty(name = "contactMobile", value = "移动电话")
    private String contactMobile;

    /**
     * 常用邮箱
     */
    @ApiModelProperty(name = "email", value = "常用邮箱")
    private String email;

    /**
     * 公司网站
     */
    @ApiModelProperty(name = "website", value = "公司网站")
    private String website;

    /**
     * 商户类型（PERSONAL 个人 INDIVIDUAL 个体工商户 ENTERPRISE 企业）
     */
    @ApiModelProperty(name = "type", value = "商户类型（PERSONAL 个人 INDIVIDUAL 个体工商户 ENTERPRISE 企业）")
    private String type;

    /**
     * 入驻时间   -- 与审核通过的auditTime 一致
     */
    @ApiModelProperty(name = "effectTime", value = "入驻时间   -- 与审核通过的auditTime 一致")
    private Date effectTime;

    /**
     * 申请时间
     */
    @ApiModelProperty(name = "createTime", value = "申请时间")
    private Date createTime;

    /**
     * 店铺数量
     */
    @ApiModelProperty(name = "shopNum", value = "店铺数量")
    private Long shopNum;

    /**
     * 商家账号
     */
    @ApiModelProperty(name = "account", value = "商家账号")
    private String account;

    /**
     * 商户id
     */
    @ApiModelProperty(name = "sellerId", value = "商户id")
    private Long sellerId;

    /**
     * 申请单状态: PENDING待审核 NORMAL正常 BANNED封禁 CORRECTION审核不通过
     */
    @ApiModelProperty(name = "status", value = "申请单状态: PENDING待审核 NORMAL正常 BANNED封禁 CORRECTION审核不通过")
    private String status;

//   经营信息：经营品牌、主营类目

    /**
     * 经营品牌
     */
    @ApiModelProperty(name = "brand", value = "经营品牌")
    private String brand;

    /**
     * 主营类目
     */
    @ApiModelProperty(name = "category", value = "主营类目")
    private String category;

    /**
     * 经营品牌
     */
    @ApiModelProperty(name = "brandList", value = "经营品牌")
    private List brandList;

    /**
     * 主营类目
     */
    @ApiModelProperty(name = "categoryList", value = "主营类目")
    private List categoryList;

    /**
     * 客服电话
     */
    @ApiModelProperty(name = "serviceTel", value = "客服电话")
    private String serviceTel;


//  主体信息
    /**
     * 公司名称
     */
    @ApiModelProperty(name = "companyName", value = "公司名称")
    private String companyName;

    /**
     * 公司地址
     */
    @ApiModelProperty(name = "address", value = "公司地址")
    private String address;

    /**
     * 固话
     */
    @ApiModelProperty(name = "contactPhone", value = "固话")
    private String contactPhone;

    /**
     * 执照类型： 1 多证合一营业执照;  2  普通营业执照
     */
    @ApiModelProperty(name = "licenseType", value = "执照类型： 1 多证合一营业执照;  2  普通营业执照")
    private Integer licenseType;

    /**
     * 统一社会信用代码
     */
    @ApiModelProperty(name = "socialCode", value = "统一社会信用代码")
    private String socialCode;

    /**
     * 营业期限起始
     */
    @ApiModelProperty(name = "tradeTermUp", value = "营业期限起始")
    private String tradeTermUp;

    /**
     * 营业期限截止
     */
    @ApiModelProperty(name = "tradeTermEnd", value = "营业期限截止")
    private String tradeTermEnd;

    /**
     * 营业执照正面
     */
    @ApiModelProperty(name = "businessLicenseA", value = "营业执照正面")
    private String businessLicenseA;

    /**
     * 营业执照背面
     */
    @ApiModelProperty(name = "businessLicenseB", value = "营业执照背面")
    private String businessLicenseB;

    /**
     * 法人
     */
    @ApiModelProperty(name = "manager", value = "法人")
    private String manager;

    /**
     * 证件类型: 1 大陆居民身份证; 2 港台澳（身份证、居民通行证）; 3 护照（限境外人士）
     */
    @ApiModelProperty(name = "cardType", value = "证件类型: 1 大陆居民身份证; 2 港台澳（身份证、居民通行证）; 3 护照（限境外人士）")
    private Integer cardType;

    /**
     * 证件有效期开始
     */
    @ApiModelProperty(name = "cardPeriodUp", value = "证件有效期开始")
    private String cardPeriodUp;

    /**
     * 证件有效期截止
     */
    @ApiModelProperty(name = "cardPeriodEnd", value = "证件有效期截止")
    private String cardPeriodEnd;

    /**
     * 证件号码
     */
    @ApiModelProperty(name = "cardNo", value = "证件号码")
    private String cardNo;

    /**
     * 证件正面
     */
    @ApiModelProperty(name = "idCardA", value = "证件正面")
    private String idCardA;

    /**
     * 证件反面
     */
    @ApiModelProperty(name = "idCardB", value = "证件反面")
    private String idCardB;

    /**
     * 商户编码
     */
    @ApiModelProperty(name = "code", value = "商户编码")
    private String code;

    /**
     * 所有人ID
     */
    @ApiModelProperty(name = "ownerId", value = "所有人ID")
    private Long ownerId;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称，选填")
    private String organizationName;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactMobile() {
        return contactMobile;
    }

    public void setContactMobile(String contactMobile) {
        this.contactMobile = contactMobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getWebsite() {
        return website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getEffectTime() {
        return effectTime;
    }

    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getServiceTel() {
        return serviceTel;
    }

    public void setServiceTel(String serviceTel) {
        this.serviceTel = serviceTel;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public Integer getLicenseType() {
        return licenseType;
    }

    public void setLicenseType(Integer licenseType) {
        this.licenseType = licenseType;
    }

    public String getSocialCode() {
        return socialCode;
    }

    public void setSocialCode(String socialCode) {
        this.socialCode = socialCode;
    }

    public String getBusinessLicenseA() {
        return businessLicenseA;
    }

    public void setBusinessLicenseA(String businessLicenseA) {
        this.businessLicenseA = businessLicenseA;
    }

    public String getBusinessLicenseB() {
        return businessLicenseB;
    }

    public void setBusinessLicenseB(String businessLicenseB) {
        this.businessLicenseB = businessLicenseB;
    }

    public String getManager() {
        return manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public Integer getCardType() {
        return cardType;
    }

    public void setCardType(Integer cardType) {
        this.cardType = cardType;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getIdCardA() {
        return idCardA;
    }

    public void setIdCardA(String idCardA) {
        this.idCardA = idCardA;
    }

    public String getIdCardB() {
        return idCardB;
    }

    public void setIdCardB(String idCardB) {
        this.idCardB = idCardB;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getShopNum() {
        return shopNum;
    }

    public void setShopNum(Long shopNum) {
        this.shopNum = shopNum;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getTradeTermUp() {
        return tradeTermUp;
    }

    public void setTradeTermUp(String tradeTermUp) {
        this.tradeTermUp = tradeTermUp;
    }

    public String getTradeTermEnd() {
        return tradeTermEnd;
    }

    public void setTradeTermEnd(String tradeTermEnd) {
        this.tradeTermEnd = tradeTermEnd;
    }

    public String getCardPeriodUp() {
        return cardPeriodUp;
    }

    public void setCardPeriodUp(String cardPeriodUp) {
        this.cardPeriodUp = cardPeriodUp;
    }

    public String getCardPeriodEnd() {
        return cardPeriodEnd;
    }

    public void setCardPeriodEnd(String cardPeriodEnd) {
        this.cardPeriodEnd = cardPeriodEnd;
    }

    public List getBrandList() {
        return brandList;
    }

    public void setBrandList(List brandList) {
        this.brandList = brandList;
    }

    public List getCategoryList() {
        return categoryList;
    }

    public void setCategoryList(List categoryList) {
        this.categoryList = categoryList;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }
}
