package com.dtyunxi.yundt.cube.center.shop.api.agg.enums;

/**
 * 店铺组件异常码30000~39999
 *
 * @author 伊泽
 * @since 1.0.0
 */
public enum ShopModuleExceptionCode {

    /**
     * 店铺组件异常码
     */
    REAUDIT_SHOP_FAIL("30000", "不能重复审核店铺"),
    SELF_MERCHANT_FAIL("30001", "创建自营商户失败"),
    SHOP_NUM_FAIL("30002", "商户下的店铺数量超出范围"),
    QUERY_MERCHANT_FAIL("30003", "查询不到对应的商户信息"),
    BIND_MERCHANT_EXIST("30004", "该账号已存在对应的商户信息"),
    AUDIT_OPINION_NULL("30005", "审核不通过时，必须填审核意见"),
    DUPLICATE_APPLY_FAIL("30006", "不能重复发起入驻申请"),
    QUERY_SHOP_FAIL("30007", "查询不到对应的店铺信息"),
    QUERY_ORGID_FAIL("30008", "查询不到对应的组织id"),
    SELLER_NOT_EXIST("30009", "商家信息不存在");


    private final String code;
    private final String msg;

    private ShopModuleExceptionCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }
}
