/**
 * @(#)ShopWarehouseDto.java 1.0 2018/9/3
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.message;

import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AreaDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

@ApiModel(value = "ShopWarehouseUpdateMessageVo", description = "仓库修改消息Vo")
public class ShopWarehouseUpdateMessageDto {

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID", required = true)
    @NotNull(message = "仓库ID不允许为空")
    private Long id;

    @ApiModelProperty(name = "warehouseId", value = "仓库code")
    private String code;

    @ApiModelProperty(name = "warehouseId", value = "仓库名称")
    private String name;

    @ApiModelProperty(value = "仓库地址坐标")
    private String coordinates;

    @ApiModelProperty(name = "geo", value = "(仓库配送类型为同城配送)应的电子围栏坐标")
    private String geoFence;

    @ApiModelProperty(name = "areaDtoList", value = "(仓库配送类型为快递)对应的配送区域范围")
    private List<AreaDto> serviceAreaList;

    @ApiModelProperty(name = "status", value = "仓库状态")
    private String status;

    @ApiModelProperty(name = "cityDeliveryStatus", value = " 同城配送启用状态：true 启用 false 不启用")
    private Boolean cityDeliveryStatus;

    @ApiModelProperty(name = "expressDeliveryStatus", value = " 快递启用状态： true 启用 false 不启用")
    private Boolean expressDeliveryStatus;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCoordinates() {
        return coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public String getGeoFence() {
        return geoFence;
    }

    public void setGeoFence(String geoFence) {
        this.geoFence = geoFence;
    }

    public List<AreaDto> getServiceAreaList() {
        return serviceAreaList;
    }

    public void setServiceAreaList(List<AreaDto> serviceAreaList) {
        this.serviceAreaList = serviceAreaList;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getCityDeliveryStatus() {
        return cityDeliveryStatus;
    }

    public void setCityDeliveryStatus(Boolean cityDeliveryStatus) {
        this.cityDeliveryStatus = cityDeliveryStatus;
    }

    public Boolean getExpressDeliveryStatus() {
        return expressDeliveryStatus;
    }

    public void setExpressDeliveryStatus(Boolean expressDeliveryStatus) {
        this.expressDeliveryStatus = expressDeliveryStatus;
    }
}
