package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 新增店铺用户关联关系请求DTO
 *
 * @author wu.tong
 * @since 1.0.0
 */
public class AddShopUserReqDto extends BaseVo{

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    @NotNull(message = "店铺ID不允许为空")
    private Long shopId;

    /**
     * 用户ID
     */
    @ApiModelProperty(name = "userId", value = "用户ID")
    @NotNull(message = "用户ID不允许为空")
    private Long userId;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID")
    @NotNull(message = "实例ID不允许为空")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
