package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

@ApiModel(discriminator = "AreaDto", description = "区域信息Dto")
public class AreaDto extends BaseVo {

    @ApiModelProperty(name = "provCode", value = "省code")
    private String provCode;

    @ApiModelProperty(name = "cityCode", value = "市code")
    private String cityCode;

    @ApiModelProperty(name = "areaCode", value = "区code")
    private String areaCode;

    public AreaDto() {
    }

    public AreaDto(String provCode, String cityCode, String areaCode) {
        this.provCode = provCode;
        this.cityCode = cityCode;
        this.areaCode = areaCode;
    }

    public AreaDto(String str) {
        if (StringUtils.isNotBlank(str)) {
            String[] array = StringUtils.split(str, ",");
            if (array.length == 1) {
                this.provCode = array[0];
            }
            if (array.length == 2) {
                this.provCode = array[0];
                this.cityCode = array[1];
            }
            if (array.length == 3) {
                this.provCode = array[0];
                this.cityCode = array[1];
                this.areaCode = array[2];
            }
        }
    }

    public String getProvCode() {
        return provCode;
    }

    public void setProvCode(String provCode) {
        this.provCode = provCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    @Override
    public String toString() {
        StringBuilder area = new StringBuilder("");
        if (StringUtils.isNotBlank(this.getProvCode())) {
            area.append(this.getProvCode());
            if (StringUtils.isNotBlank(this.getCityCode())) {
                area.append(",");
                area.append(this.getCityCode());
                if (StringUtils.isNotBlank(this.getAreaCode())) {
                    area.append(",");
                    area.append(this.getAreaCode());
                }
            }
        }
        return area.toString();
    }

}