/*
 * @(#)AuditDataDto.java 1.0 2018/9/3
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;
import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 待审核信息请求Dto
 *
 * @author 华生
 * @since 1.0.0
 */
@ApiModel(value = "AuditDataRespDto", description = "待审核信息Dto")
public class AuditDataReqDto extends BaseVo {


    /**
     * 待审核信息Id
     */
    @ApiModelProperty(name = "id", value = "待审核信息id")
    @NotNull(message = "待审核信息id不能为空")
    private Long id;


    /**
     * 业务Id
     */
    @ApiModelProperty(name = "businessId", value = "业务Id")
    @NotNull(message = "业务id不能为空")
    private Long businessId;


    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;


    /**
     * 状态(PENDING：待审核；PASS：审核通过；REFUSE：审核拒绝)
     */
    @ApiModelProperty(name = "status", value = "待审核信息状态")
    @NotNull(message = "待审核信息状态不能为空")
    private String status;

    /**
     * 审核结果
     */
    @ApiModelProperty(name = "result", value = "审核结果")
    private String result;

    /**
     * 审核人
     */
    @ApiModelProperty(name = "auditPerson", value = "审核人")
    @NotNull(message = "审核人不能为空")
    private String auditPerson;

    /**
     * 审核时间
     */
    @ApiModelProperty(name = "auditTime", value = "审核时间")
    @NotNull(message = "审核时间")
    private Date auditTime;

    /**
     * 数据存储域
     */
    @ApiModelProperty(name = "data", value = "数据存储域")
    @NotNull(message = "数据存储域不能为空")
    private String data;

    /**
     * 实例化Id
     */
    @ApiModelProperty(name = "instanceId", value = "实例Id")
    @NotNull(message = "实例Id不能为空")
    private Long instanceId;

    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(String auditPerson) {
        this.auditPerson = auditPerson;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
