package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 审核信息查询条件请求DTO
 *
 * @author wu.tong
 * @since 1.0.0
 */
@ApiModel(value = "AuditQueryReqDto",description = "审核信息查询条件请求DTO")
public class AuditQueryReqDto extends BaseVo{

    /**
     * 每页页大小
     */
    @ApiModelProperty(name = "pageSize",value = "每页页大小")
    private int pageSize = 10;

    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum",value = "页码")
    private int pageNum = 1;

    /**
     * 业务ID
     */
    @ApiModelProperty(name = "businessId",value = "业务ID")
    private Long businessId;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType",value = "业务类型")
    private String businessType;

    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;

    /**
     * 状态(PENDING：待审核；PASS：审核通过；REFUSE：审核拒绝)
     */
    @ApiModelProperty(name = "status",value = "状态(PENDING：待审核；PASS：审核通过；REFUSE：审核拒绝)")
    private String status;

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}
