package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(value = "DeliveryPeriodDto", description = "配送时间配置")
public class DeliveryPeriodDto {

    @ApiModelProperty(name = "deliveryAllDay", value = "是否全天配送")
    private Boolean deliveryAllDay;

    @ApiModelProperty(name = "deliveryPeriodList", value = "配送时间段", example = "时间范围例子: [0-6,9-12,15-18]")
    private List<String> deliveryPeriodList = Lists.newArrayList();

    @ApiModelProperty(name = "timeInterval", value = "时间间隔")
    private String timeInterval;

    @ApiModelProperty(name = "predictPickTime", value = "预留提货时间")
    private String predictPickTime;

    public Boolean getDeliveryAllDay() {
        return deliveryAllDay;
    }

    public void setDeliveryAllDay(Boolean deliveryAllDay) {
        this.deliveryAllDay = deliveryAllDay;
    }

    public List<String> getDeliveryPeriodList() {
        return deliveryPeriodList;
    }

    public void setDeliveryPeriodList(List<String> deliveryPeriodList) {
        this.deliveryPeriodList = deliveryPeriodList;
    }

    public String getTimeInterval() {
        return timeInterval;
    }

    public void setTimeInterval(String timeInterval) {
        this.timeInterval = timeInterval;
    }

    public String getPredictPickTime() {
        return predictPickTime;
    }

    public void setPredictPickTime(String predictPickTime) {
        this.predictPickTime = predictPickTime;
    }
}
