/*
 * @(#)SellerBusinessScopeDto.java 1.0 2018/9/3
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 商户经营范围Dto请求类
 *
 * @author 华生
 * @since 1.0.0
 */

@ApiModel(value = "SellerBusinessScopeReqDto", description = "商户经营区域请求Dto")
public class SellerBusinessScopeReqDto extends BaseVo{

    private static final long serialVersionUID = -5324816866440464348L;

    /**
     * Id
     */
    @ApiModelProperty(name = "Id", value = "Id，新增不填，修改必填")
    private Long Id;


    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID，新增时此参数值无效，修改必填")
    private Long sellerId;

    /**
     * 业务ID
     */
    @ApiModelProperty(name = "businessId", value = "业务ID，必填")
    @NotNull
    private Long businessId;

    /**
     * 业务类型，区分类目(CATEGORY)，品牌(BRAND)，渠道(CHANNEL)
     */
    @ApiModelProperty(name = "businessType", value = "业务类型，必填")
    @NotNull
    private String businessType;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID，必填")
    @NotNull
    private Long instanceId;


    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID，选填")
    private Long tenantId;

    @ApiModelProperty(name = "dr", value = "dr，选填，默认为0")
    private Integer dr;

    public Integer getDr() {
        return dr;
    }

    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getId() {return Id;}

    public void setId(Long id) {Id = id;}

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}
