package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * 商户查询请求Dto
 *
 * @author wu.tong
 * @since 1.0.0
 */
@ApiModel(value = "SellerQueryReqDto", description = "商户查询请求Dto")
public class SellerQueryReqDto extends BaseVo {


    /**
     * 商户id
     */
    @ApiModelProperty(name = "id", value = "商户id，选填")
    private Long id;

    /**
     * 每页页大小
     */
    @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
    private int pageSize = 10;

    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum", value = "页码，选填")
    private int pageNum = 1;

    /**
     * 商户编码
     */
    @ApiModelProperty(name = "code", value = "商户编码，选填")
    private String code;

    /**
     * 商户名称（支持模糊搜索）
     */
    @ApiModelProperty(name = "name", value = "商户名称(支持模糊搜索)，选填")
    private String name;

    /**
     * 商户类型（PERSONAL 个人 INDIVIDUAL 个体工商户 ENTERPRISE 企业）
     */
    @ApiModelProperty(name = "type", value = "商户类型（PERSONAL 个人 INDIVIDUAL 个体工商户 ENTERPRISE 企业），选填")
    private String type;

    /**
     * 地址
     */
    @ApiModelProperty(name = "address", value = "地址，选填")
    private String address;

    /**
     * 联系人
     */
    @ApiModelProperty(name = "contactPerson", value = "联系人，选填")
    private String contactPerson;

    /**
     * 移动电话
     */
    @ApiModelProperty(name = "contactMobile", value = "移动电话，选填")
    private String contactMobile;

    /**
     * 固话
     */
    @ApiModelProperty(name = "contactPhone", value = "固话，选填")
    private String contactPhone;

    /**
     * 公司名称（支持模糊搜索）
     */
    @ApiModelProperty(name = "companyName", value = "公司名称(支持模糊搜索)，选填")
    private String companyName;


    /**
     * 状态。NORMAL正常 BANNED封禁 CORRECTION整改
     */
    @ApiModelProperty(name = "status", value = "状态。NORMAL正常 BANNED封禁 CORRECTION整改，选填")
    private String status;

    /**
     * 所有人id
     */
    @ApiModelProperty(name = "ownerId", value = "所有人id，选填")
    private Long ownerId;

    /**
     * 分组id
     */
    @ApiModelProperty(name = "groupId", value = "分组id，选填")
    private Long groupId;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称，选填")
    private String organizationName;

    /**
     * 组织ids
     */
    private List<Long> organizationIds;

    /**
     * 商家ids
     */
    private List<Long> idList;

    /**
     * 实例id
     */
    @ApiModelProperty(name = "instanceId", value = "实例id，选填")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户id，选填")
    private Long tenantId;


    /**
     * 法人
     */
    @ApiModelProperty(name = "manager", value = "法人，选填")
    private String manager;


    /**
     * 开通时间
     */
    @ApiModelProperty(name = "createTime", value = "开通时间，选填")
    private Date createTime;

    /**
     * 业务ID
     */
    @ApiModelProperty(name = "businessId", value = "业务ID")
    private Long businessId;

    /**
     * 业务类型，区分类目(CATEGORY)，品牌(BRAND)，渠道(CHANNEL)
     */
    @ApiModelProperty(name = "businessType", value = "业务类型，区分类目(CATEGORY)，品牌(BRAND)，渠道(CHANNEL)")
    private String businessType;

    @ApiModelProperty(name = "isFactoryDelivery", value = "是否厂家发货")
    private Integer isFactoryDelivery;

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactMobile() {
        return contactMobile;
    }

    public void setContactMobile(String contactMobile) {
        this.contactMobile = contactMobile;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getManager() {
        return manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    public Date getCreateTime() {
        return createTime;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public List<Long> getOrganizationIds() {
        return organizationIds;
    }

    public void setOrganizationIds(List<Long> organizationIds) {
        this.organizationIds = organizationIds;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public List<Long> getIdList() {
        return idList;
    }

    public void setIdList(List<Long> idList) {
        this.idList = idList;
    }

    public Integer getIsFactoryDelivery() {
        return isFactoryDelivery;
    }

    public void setIsFactoryDelivery(Integer isFactoryDelivery) {
        this.isFactoryDelivery = isFactoryDelivery;
    }
}
