/*
 * @(#)SellerDto.java 1.0 2018/9/3
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 商户Dto请求类
 *
 * @author 华生
 * @since 1.0.0
 */

@ApiModel(value = "SellerReqDto", description = "商户请求Dto")
public class SellerReqDto extends BaseVo {

    private static final long serialVersionUID = -5324816766440464348L;

    /**
     * 商户id
     */
    @ApiModelProperty(name = "id", value = "商户id,新增不填，修改必填")
    private Long id;

    /**
     * 商户编码
     */
    @ApiModelProperty(name = "code", value = "商户编码，必填")
    private String code;

    /**
     * 商户类型
     */
    @ApiModelProperty(name = "type", value = "商户类型(PERSONAL 个人 INDIVIDUAL 个体工商户 ENTERPRISE 企业)，选填")
    private String type;

    /**
     * 商户名称
     */
    @ApiModelProperty(name = "name", value = "商户名称，必填")
    @NotNull(message = "商户名称不能为空")
    private String name;

    /**
     * 公司地址
     */
    @ApiModelProperty(name = "address", value = "地址，选填")
    private String address;

    /**
     * 联系人
     */
    @ApiModelProperty(name = "contactPerson", value = "联系人，选填")
    private String contactPerson;

    /**
     * 移动电话
     */
    @ApiModelProperty(name = "contactMobile", value = "移动电话，选填")
    private String contactMobile;

    /**
     * 固话
     */
    @ApiModelProperty(name = "contactPhone", value = "固话，选填")
    private String contactPhone;

    /**
     * 公司名称
     */
    @ApiModelProperty(name = "companyName", value = "公司名称，选填")
    private String companyName;


    /**
     * 营业执照A
     */
    @ApiModelProperty(name = " businessLicenseA", value = "营业执照A，选填")
    private String businessLicenseA;

    /**
     * 营业执照B
     */
    @ApiModelProperty(name = "businessLicenseB", value = "营业执照B，选填")
    private String businessLicenseB;

    /**
     * 身份证正面
     */
    @ApiModelProperty(name = "idCardA", value = "身份证正面，选填")
    private String idCardA;

    /**
     * 身份证反面
     */
    @ApiModelProperty(name = "idCardB", value = "身份证反面，选填")
    private String idCardB;

    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "组ID，选填")
    private Long groupId;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称，选填")
    private String organizationName;

    /**
     * 商户状态 (DRAFT草稿PENDING待审核 NORMAL正常 BANNED封禁 CORRECTION整改)
     */
    @ApiModelProperty(name = "status", value = "商户状态(DRAFT草稿,PENDING待审核,NORMAL正常 BANNED封禁 CORRECTION整改)" +
            "，选填，新增时调用接口ISellerApi#addSeller请求参数audit值为false时，" +
            "或修改时调用接口ISellerApi#modifySeller请求参数needAudit值为false时，此参数值无效")
    private String status;

    /**
     * 所有人ID
     */
    @ApiModelProperty(name = "ownerId", value = "所有人ID，必填")
    private Long ownerId;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID，必填")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID，选填")
    private Long tenantId;


    @ApiModelProperty(name = "dr", value = "dr，选填，默认为0")
    private Integer dr;


    /**
     * 商户经营范围，存放类型，品牌，渠道等信息
     */
    @ApiModelProperty(name = "sellerBusinessScopeReqDtoList", value = "商户经营范围，选填，新增时调用接口ISellerApi#addSeller请求参数audit" +
            "值为true时，" +
            "或修改时调用接口ISellerApi#modifySeller请求参数needAudit值为true时，" +
            "此参数值保存至审核信息sc_audit_data.data字段中，" +
            "当调用接口ISellerApi#auditSeller审核店铺信息通过时，会再保存信息至表sc_seller_business_scope商户经营范围里")
    private List<SellerBusinessScopeReqDto> sellerBusinessScopeReqDtoList;


    /**
     * 商户经营区域
     */
    @ApiModelProperty(name = "sellerAreaDtoList", value = "商户经营区域")
    private List<SellerAreaDto> sellerAreaDtoList;


    /**
     * 开通时间
     */
    @ApiModelProperty(name = "createTime", value = "开通时间，选填")
    private Date createTime;


    /**
     * 法人
     */
    @ApiModelProperty(name = "manager", value = "法人，选填")
    private String manager;

    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json，选填")
    private String extension;

    @ApiModelProperty("申请类型(ADD:新增,UPDATE修改)用于标记是编辑还是新增触发的审核")
    private String applyType;
    @ApiModelProperty("客户ID")
    private Long customerId;

    @ApiModelProperty("第三方租户id")
    private String thirdSellerId;

    @ApiModelProperty(name = "isFactoryDelivery", value = "是否厂家发货")
    private Integer isFactoryDelivery;

    public String getThirdSellerId() {
        return thirdSellerId;
    }

    public void setThirdSellerId(String thirdSellerId) {
        this.thirdSellerId = thirdSellerId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactMobile() {
        return contactMobile;
    }

    public void setContactMobile(String contactMobile) {
        this.contactMobile = contactMobile;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getBusinessLicenseA() {
        return businessLicenseA;
    }

    public void setBusinessLicenseA(String businessLicenseA) {
        this.businessLicenseA = businessLicenseA;
    }

    public String getBusinessLicenseB() {
        return businessLicenseB;
    }

    public void setBusinessLicenseB(String businessLicenseB) {
        this.businessLicenseB = businessLicenseB;
    }

    public String getIdCardA() {
        return idCardA;
    }

    public void setIdCardA(String idCardA) {
        this.idCardA = idCardA;
    }

    public String getIdCardB() {
        return idCardB;
    }

    public void setIdCardB(String idCardB) {
        this.idCardB = idCardB;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<SellerBusinessScopeReqDto> getSellerBusinessScopeReqDtoList() {
        return sellerBusinessScopeReqDtoList;
    }

    public void setSellerBusinessScopeReqDtoList(List<SellerBusinessScopeReqDto> sellerBusinessScopeReqDtoList) {
        this.sellerBusinessScopeReqDtoList = sellerBusinessScopeReqDtoList;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }


    public Integer getDr() {
        return dr;
    }

    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public String getManager() {
        return manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    public Date getCreateTime() {
        return createTime;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public List<SellerAreaDto> getSellerAreaDtoList() {
        return sellerAreaDtoList;
    }

    public void setSellerAreaDtoList(List<SellerAreaDto> sellerAreaDtoList) {
        this.sellerAreaDtoList = sellerAreaDtoList;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getApplyType() {
        return applyType;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Integer getIsFactoryDelivery() {
        return isFactoryDelivery;
    }

    public void setIsFactoryDelivery(Integer isFactoryDelivery) {
        this.isFactoryDelivery = isFactoryDelivery;
    }
}
