/**
 * @(#)ShopAreaDto.java 1.0 2018/9/3
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import javax.validation.constraints.NotNull;

import com.dtyunxi.vo.BaseVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 店铺经营区域Dto
 *
 * @author 风信
 * @since 1.0.0
 */
@ApiModel(value = "ShopAreaDto", description = "店铺经营区域Dto")
public class ShopAreaDto extends BaseVo{

    /**
     * 主键ID
     */
    @ApiModelProperty(name = "id", value = "主键ID，新增时不填，修改时必填")
    private Long id ;

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID，必填")
    @NotNull(message = "店铺ID不允许为空")
    private Long shopId;

    /**
     * 区域编码
     */
    @ApiModelProperty(name = "areaCode", value = "区域编码，必填")
    @NotNull(message = "区域编码不允许为空")
    private String areaCode;

    /**
     * 区域级别，例如省市区街道
     */
    @ApiModelProperty(name = "areaLevel", value = "区域级别，例如省市区街道，必填")
    @NotNull(message = "区域级别不允许为空")
    private String areaLevel;

    @ApiModelProperty(name = "provinceCode", value = "省份编码, 选填")
    private String provinceCode;

    @ApiModelProperty(name = "province", value = "省份, 选填")
    private String province;

    @ApiModelProperty(name = "cityCode", value = "地市编码, 选填")
    private String cityCode;

    @ApiModelProperty(name = "city", value = "地市, 选填")
    private String city;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;

    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId ;

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaLevel() {
        return areaLevel;
    }

    public void setAreaLevel(String areaLevel) {
        this.areaLevel = areaLevel;
    }

    public Long getShopId() {

        return shopId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
}
