/**
 * @(#)ShopBusinessScopeDto.java 1.0 2018/9/3
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 店铺运营范围Dto
 *
 * @author 风信
 * @since 1.0.0
 */
@ApiModel(value = "ShopBusinessScopeDto", description = "店铺运营范围Dto")
public class ShopBusinessScopeDto extends BaseVo {

    private Long id ;

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID，必填")
    @NotNull(message = "店铺ID不允许为空")
    private Long shopId;

    /**
     * 业务ID，类目，品牌，渠道等ID
     */
    @ApiModelProperty(name = "businessId", value = "业务ID，类目，品牌，渠道,客户区域等ID，必填")
    @NotNull(message = "业务ID不允许为空")
    private Long businessId;

    /**
     * 业务类型，区分类目，品牌，渠道
     */
    @ApiModelProperty(name = "businessType", value = "业务类型，区分类目，品牌，渠道，客户区域,必填(品牌:2  skuId:3 分类:4  区域:5  排除skuI:6)")
    @NotNull(message = "业务类型不允许为空")
    private String businessType;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;


    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId ;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
