package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.math.BigDecimal;

@ApiModel(value = "ShopDeliveryDto", description = "店铺同城配送DTO")
public class ShopDeliveryDto extends BaseVo {

    @ApiModelProperty(value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(value = "商家ID")
    private Long sellerId;

    @ApiModelProperty(value = "是否默认为模板")
    private Integer isDefault;

    //O2O店铺地址信息<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    @ApiModelProperty(name = "addressProvince", value = "取货地址省份")
    private String addressProvince;

    @ApiModelProperty(name = "addressCity", value = "取货地址市")
    private String addressCity;

    @ApiModelProperty(name = "addressRegion", value = "取货地址区")
    private String addressRegion;

    @ApiModelProperty(value = "店铺取货地址坐标")
    private String geo;

    @ApiModelProperty(name = "geoFence", value = "O2O店铺配送范围的地址围栏")
    private String geoFence;

    @ApiModelProperty(name = "addressProvinceName", value = "取货地址省份名称")
    private String addressProvinceName;

    @ApiModelProperty(name = "addressCityName", value = "取货地址市名称")
    private String addressCityName;

    @ApiModelProperty(name = "addressRegionName", value = "取货地址区名称")
    private String addressRegionName;

    @ApiModelProperty(name = "detailAddress", value = "取货详细地址")
    private String detailAddress;

    @ApiModelProperty(name = "deliveryParty", value = "配送方")
    private Integer deliveryParty;

    @ApiModelProperty(name = "cityDeliveryPeriod", value = "同城配送配送时间")
    private DeliveryPeriodDto cityDeliveryPeriod;

    @ApiModelProperty(name = "selfPickUpPeriod", value = "上门自提时间")
    private DeliveryPeriodDto selfPickUpPeriod;


    // TODO: 2021/3/3 废弃字段
    @ApiModelProperty(name = "initialPrice", value = "起送价")
    private BigDecimal initialPrice;

    @ApiModelProperty(name = "startValue", value = "启动费用")
    private BigDecimal startValue;

    @ApiModelProperty(name = "startFee", value = "起送费用")
    private BigDecimal startFee;

    @ApiModelProperty(name = "overValue", value = "超出距离")
    private BigDecimal overValue;

    @ApiModelProperty(name = "overFee", value = "超出费用")
    private BigDecimal overFee;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public String getAddressProvince() {
        return addressProvince;
    }

    public void setAddressProvince(String addressProvince) {
        this.addressProvince = addressProvince;
    }

    public String getAddressCity() {
        return addressCity;
    }

    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    public String getAddressRegion() {
        return addressRegion;
    }

    public void setAddressRegion(String addressRegion) {
        this.addressRegion = addressRegion;
    }

    public String getAddressProvinceName() {
        return addressProvinceName;
    }

    public void setAddressProvinceName(String addressProvinceName) {
        this.addressProvinceName = addressProvinceName;
    }

    public String getAddressCityName() {
        return addressCityName;
    }

    public void setAddressCityName(String addressCityName) {
        this.addressCityName = addressCityName;
    }

    public String getAddressRegionName() {
        return addressRegionName;
    }

    public void setAddressRegionName(String addressRegionName) {
        this.addressRegionName = addressRegionName;
    }

    public String getDetailAddress() {
        return detailAddress;
    }

    public void setDetailAddress(String detailAddress) {
        this.detailAddress = detailAddress;
    }

    public Integer getDeliveryParty() {
        return deliveryParty;
    }

    public void setDeliveryParty(Integer deliveryParty) {
        this.deliveryParty = deliveryParty;
    }

    public BigDecimal getInitialPrice() {
        return initialPrice;
    }

    public void setInitialPrice(BigDecimal initialPrice) {
        this.initialPrice = initialPrice;
    }

    public BigDecimal getStartValue() {
        return startValue;
    }

    public void setStartValue(BigDecimal startValue) {
        this.startValue = startValue;
    }

    public BigDecimal getStartFee() {
        return startFee;
    }

    public void setStartFee(BigDecimal startFee) {
        this.startFee = startFee;
    }

    public BigDecimal getOverValue() {
        return overValue;
    }

    public void setOverValue(BigDecimal overValue) {
        this.overValue = overValue;
    }

    public BigDecimal getOverFee() {
        return overFee;
    }

    public void setOverFee(BigDecimal overFee) {
        this.overFee = overFee;
    }

    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public DeliveryPeriodDto getCityDeliveryPeriod() {
        return cityDeliveryPeriod;
    }

    public void setCityDeliveryPeriod(DeliveryPeriodDto cityDeliveryPeriod) {
        this.cityDeliveryPeriod = cityDeliveryPeriod;
    }

    public DeliveryPeriodDto getSelfPickUpPeriod() {
        return selfPickUpPeriod;
    }

    public void setSelfPickUpPeriod(DeliveryPeriodDto selfPickUpPeriod) {
        this.selfPickUpPeriod = selfPickUpPeriod;
    }

    public String getGeoFence() {
        return geoFence;
    }

    public void setGeoFence(String geoFence) {
        this.geoFence = geoFence;
    }
}
