package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author xiaoyuan
 * @since 1.0.0
 */
@ApiModel(value = "ShopDirFreightDto", description = "店铺类目运费模板")
public class ShopDirFreightDto extends BaseVo {

	@ApiModelProperty(name = "shopId", value = "店铺id")
	private Long shopId;

	@ApiModelProperty(name = "backDirId", value = "后台类目id")
	@NotNull(message = "后台类目id不允许为空")
	private Long backDirId;

	@ApiModelProperty(name = "freightTemplateId", value = "运费模板id")
	@NotNull(message = "运费模板id不允许为空")
	private Long freightTemplateId;

	@ApiModelProperty(name = "backParentDirId", value = "后台类目父级id，多个以逗号隔开")
	private String backParentDirId;

	@ApiModelProperty(name = "backDirIdList", value = "后台类目id列表")
	private List<Long> backDirIdList;

	private Integer num;

	public Long getBackDirId() {
		return backDirId;
	}

	public void setBackDirId(Long backDirId) {
		this.backDirId = backDirId;
	}

	public Long getFreightTemplateId() {
		return freightTemplateId;
	}

	public void setFreightTemplateId(Long freightTemplateId) {
		this.freightTemplateId = freightTemplateId;
	}

	public Long getShopId() {
		return shopId;
	}

	public void setShopId(Long shopId) {
		this.shopId = shopId;
	}

	public List<Long> getBackDirIdList() {
		return backDirIdList;
	}

	public void setBackDirIdList(List<Long> backDirIdList) {
		this.backDirIdList = backDirIdList;
	}

	public String getBackParentDirId() {
		return backParentDirId;
	}

	public void setBackParentDirId(String backParentDirId) {
		this.backParentDirId = backParentDirId;
	}

	public Integer getNum() {
		if (!StringUtils.isEmpty(this.getBackParentDirId())){
			return this.getBackParentDirId().split(",").length;
		}
		return num;
	}

	public void setNum(Integer num) {
		this.num = num;
	}
}