/**
 * @(#)ShopDto.java 1.0 2018/9/3
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopAddressRespDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 店铺基本信息Dto
 *
 * @author 风信
 * @since 1.0.0
 */
@ApiModel(value = "ShopDto", description = "店铺信息Dto")
public class ShopDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "店铺ID")
    private Long id;

    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;

    @ApiModelProperty(name = "sellerId", value = "商户ID，必填", required = true)
    @NotNull(message = "商户ID不允许为空")
    private Long sellerId;

    @ApiModelProperty(name = "code", value = "店铺编码，选填。如果没有提供，店铺中心生成分布式ID作为店铺编码")
    private String code;

    @ApiModelProperty(name = "name", value = "店铺名称，必填", required = true)
    @NotNull(message = "店铺名称不允许为空")
    private String name;

    @ApiModelProperty(name = "type", value = "店铺类型：1 线上业务, 2 O2O业务")
    private Long type;

    @ApiModelProperty(name = "manageType", value = "运营类型：1-直营；2- 加盟")
    private Integer manageType;

    @ApiModelProperty(name = "businessType", value = "业务类型: 1 快递 , 2 O2O(同城配送/到店自提)", required = true)
    private Integer businessType;

    @ApiModelProperty(name = "businessForm", value = "营业形态：暂无（给项目组使用，由项目组确定）")
    private Integer businessForm;

    @ApiModelProperty(name = "level", value = "店铺等级")
    private Integer level;

    @ApiModelProperty(name = "contactPerson", value = "联系人，选填")
    private String contactPerson;

    @ApiModelProperty(name = "contactPhone", value = "联系电话，选填")
    private String contactPhone;

    @ApiModelProperty(name = "shopUrl", value = "url地址")
    private String shopUrl;

    @ApiModelProperty(name = "status", value = "状态，必填：NORMAL正常 BANNED封禁 CORRECTION整改")
    private String status;

    @ApiModelProperty(name = "shopIntroduction", value = "店铺简介，选填")
    private String shopIntroduction;

    @ApiModelProperty(name = "logo", value = "店铺logo，选填")
    private String logo;

    //店铺组织信息<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;

    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    //店铺其他信息<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    @ApiModelProperty(name = "deliveryType", value = "店铺支持的物流方式")
    private String deliveryType;

    @ApiModelProperty(name = "cityDelivery", value = "是否开启同城配送")
    private Boolean cityDelivery;

    @ApiModelProperty(name = "selfPickUp", value = "是否开启自提")
    private Boolean selfPickUp;

    @ApiModelProperty(name = "autoReceive", value = "是否开启自动接单")
    private Boolean autoReceive;

    @ApiModelProperty(name = "shopAreaDto", value = "店铺经营区域Dto(暂时没有用到)")
    private List<ShopAreaDto> shopAreaDto;

    @ApiModelProperty(name = "isFreightFirst", value = "是否店铺优先:0否1是")
    private Integer isFreightFirst;
    @ApiModelProperty(name = "freightCountRule", value = "运费计算规则:1最大值 2 叠加计算")
    private Integer freightCountRule;
    @ApiModelProperty(name = "freightTemplateId", value = "运费模板id")
    private Long freightTemplateId;
    @ApiModelProperty(name = "freightTemplateName", value = "运费模板名称")
    private String freightTemplateName;

    @ApiModelProperty(name = "shopFreightType", value = "运费模板类型:1店铺统一，2按类目统一，3商品自定义")
//    @NotNull(message = "运费模板类型不允许为空")
    private Integer shopFreightType;

    @ApiModelProperty(name = "deliveryAreaDtoList", value = "线上店铺配送区域")
    private List<DeliveryAreaDto> deliveryAreaDtoList;

    @ApiModelProperty(name = "freightCountType", value = "运费计算规则: 0 最大值 1 叠加计算")
    private Integer freightCountType;

    @ApiModelProperty(name = "freightMailType", value = "运费包邮类型: 0 其中一个SKU满足包邮条件, 1 所有SKU满足包邮条件")
    private Integer freightMailType;

    @ApiModelProperty(name = "shopDeliveryDto", value = "O2O店铺关联信息")
    private ShopDeliveryDto shopDeliveryDto;

    @ApiModelProperty(name = "transportPartnerDtoList", value = "配送方信息")
    private List<ShopTransportPartnerDto> transportPartnerDtoList;

    @ApiModelProperty(name = "shopAddressList", value = "地址列表dto(店铺的退货地址信息)")
    private List<ShopAddressRespDto> shopAddressList;

    //店铺退货地址信息<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    @ApiModelProperty(name = "provinceCode", value = "省份编码，选填")
    private String provinceCode;

    @ApiModelProperty(name = "cityCode", value = "地市编码，选填")
    private String cityCode;

    @ApiModelProperty(name = "countyCode", value = "区编码，选填")
    private String countyCode;

    @ApiModelProperty(name = "streetCode", value = "街道编码，选填")
    private String streetCode;

    @ApiModelProperty(name = "address", value = "地址，选填")
    private String address;

    @ApiModelProperty(name = "geo", value = "店铺退地址坐标：x，y")
    private String geo;

    //其它信息---------------------------------------------------------------------------
    @ApiModelProperty(name = "shopBusinessScopeDto", value = "店铺运营范围Dto，选填")
    private List<ShopBusinessScopeDto> shopBusinessScopeDto;

    @ApiModelProperty(name = "serviceTel", value = "客服电话")
    private String serviceTel;

    @ApiModelProperty(name = "sellerName", value = "卖家名字")
    private String sellerName;

    @ApiModelProperty(name = "sellerCode", value = "卖家编码")
    private String sellerCode;


    @ApiModelProperty(name = "extension", value = "扩展字段，存放json，选填")
    private String extension;

    @ApiModelProperty(name = "owner", value = "所属人ID，选填")
    private Long owner;

    @ApiModelProperty(name = "isWxacodeDownload", value = "店铺是否已经下载过小程序码：1是，0否")
    private Integer isWxacodeDownload;

    @ApiModelProperty(name = "workTime", value = "工作时间，选填")
    private String workTime;

    @ApiModelProperty(name = "selfId", value = "店铺ID")
    private Long selfId;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    @ApiModelProperty(name = "updatePerson", value = "修改人")
    private String updatePerson;

    @ApiModelProperty(name = "updateTime", value = "修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("客户ID")
    private Long customerId;


    // TODO: 2021/3/2 要删除的字段
    @ApiModelProperty(name = "shopWarehouseDto", value = "店铺仓库Dto，选填")
    private List<ShopWarehouseDto> shopWarehouseDto;

    @ApiModelProperty(name = "channelIdList", value = "店铺渠道ID")
    private List<ShopChannelDto> shopChannelList;

    @ApiModelProperty(name = "channelCode", value = "渠道code")
    private String channelCode;

    @ApiModelProperty(name = "auth_status", value = "授权状态")
    private Integer authStatus;

    @ApiModelProperty(name = "itemSyncSwitch", value = "商品渠道同步开关")
    private Integer itemSyncSwitch;

    @ApiModelProperty(name = "shopDirFreightDtoList", value = "按类目统一的类目运费关联list")
    private List<ShopDirFreightDto> shopDirFreightDtoList;

    @ApiModelProperty(name = "idCard", value = "身份证号码")
    private String idCard;


    @ApiModelProperty("收款 方式(商家收款:SHOP_RECEIVE)")
    private String collectionTypes;

    @ApiModelProperty("仓库IDs")
    private List<Long> shopWarehouseIds;

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCollectionTypes() {
        return collectionTypes;
    }

    public void setCollectionTypes(String collectionTypes) {
        this.collectionTypes = collectionTypes;
    }

    public Integer getFreightCountRule() {
        return freightCountRule;
    }

    public void setFreightCountRule(Integer freightCountRule) {
        this.freightCountRule = freightCountRule;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public Integer getIsWxacodeDownload() {
        return isWxacodeDownload;
    }

    public void setIsWxacodeDownload(Integer isWxacodeDownload) {
        this.isWxacodeDownload = isWxacodeDownload;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getType() {
        return type;
    }

    public void setType(Long tpye) {
        this.type = tpye;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getShopUrl() {
        return shopUrl;
    }

    public void setShopUrl(String shopUrl) {
        this.shopUrl = shopUrl;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public String getShopIntroduction() {
        return shopIntroduction;
    }

    public void setShopIntroduction(String shopIntroduction) {
        this.shopIntroduction = shopIntroduction;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(String deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getWorkTime() {
        return workTime;
    }

    public void setWorkTime(String workTime) {
        this.workTime = workTime;
    }

    public Long getSelfId() {
        return selfId;
    }

    public void setSelfId(Long selfId) {
        this.selfId = selfId;
    }

    public List<ShopAreaDto> getShopAreaDto() {
        return shopAreaDto;
    }

    public void setShopAreaDto(List<ShopAreaDto> shopAreaDto) {
        this.shopAreaDto = shopAreaDto;
    }

    public List<ShopBusinessScopeDto> getShopBusinessScopeDto() {
        return shopBusinessScopeDto;
    }

    public void setShopBusinessScopeDto(List<ShopBusinessScopeDto> shopBusinessScopeDto) {
        this.shopBusinessScopeDto = shopBusinessScopeDto;
    }

    public List<ShopAddressRespDto> getShopAddressList() {
        return shopAddressList;
    }

    public void setShopAddressList(List<ShopAddressRespDto> shopAddressList) {
        this.shopAddressList = shopAddressList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getOwner() {
        return owner;
    }

    public void setOwner(Long owner) {
        this.owner = owner;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Integer getManageType() {
        return manageType;
    }

    public void setManageType(Integer manageType) {
        this.manageType = manageType;
    }

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    public Integer getBusinessForm() {
        return businessForm;
    }

    public void setBusinessForm(Integer businessForm) {
        this.businessForm = businessForm;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public ShopDeliveryDto getShopDeliveryDto() {
        return shopDeliveryDto;
    }

    public void setShopDeliveryDto(ShopDeliveryDto shopDeliveryDto) {
        this.shopDeliveryDto = shopDeliveryDto;
    }

    public List<ShopTransportPartnerDto> getTransportPartnerDtoList() {
        return transportPartnerDtoList;
    }

    public void setTransportPartnerDtoList(List<ShopTransportPartnerDto> transportPartnerDtoList) {
        this.transportPartnerDtoList = transportPartnerDtoList;
    }

    public Boolean getCityDelivery() {
        return cityDelivery;
    }

    public void setCityDelivery(Boolean cityDelivery) {
        this.cityDelivery = cityDelivery;
    }

    public Boolean getSelfPickUp() {
        return selfPickUp;
    }

    public void setSelfPickUp(Boolean selfPickUp) {
        this.selfPickUp = selfPickUp;
    }

    public Boolean getAutoReceive() {
        return autoReceive;
    }

    public void setAutoReceive(Boolean autoReceive) {
        this.autoReceive = autoReceive;
    }

    public String getServiceTel() {
        return serviceTel;
    }

    public void setServiceTel(String serviceTel) {
        this.serviceTel = serviceTel;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public List<ShopWarehouseDto> getShopWarehouseDto() {
        return shopWarehouseDto;
    }

    public void setShopWarehouseDto(List<ShopWarehouseDto> shopWarehouseDto) {
        this.shopWarehouseDto = shopWarehouseDto;
    }

    public List<ShopChannelDto> getShopChannelList() {
        return shopChannelList;
    }

    public void setShopChannelList(List<ShopChannelDto> shopChannelList) {
        this.shopChannelList = shopChannelList;
    }

    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public String getFreightTemplateName() {
        return freightTemplateName;
    }

    public void setFreightTemplateName(String freightTemplateName) {
        this.freightTemplateName = freightTemplateName;
    }

    public Integer getIsFreightFirst() {
        return isFreightFirst;
    }

    public void setIsFreightFirst(Integer isFreightFirst) {
        this.isFreightFirst = isFreightFirst;
    }

    public List<DeliveryAreaDto> getDeliveryAreaDtoList() {
        return deliveryAreaDtoList;
    }

    public void setDeliveryAreaDtoList(List<DeliveryAreaDto> deliveryAreaDtoList) {
        this.deliveryAreaDtoList = deliveryAreaDtoList;
    }

    public Integer getFreightCountType() {
        return freightCountType;
    }

    public void setFreightCountType(Integer freightCountType) {
        this.freightCountType = freightCountType;
    }

    public Integer getFreightMailType() {
        return freightMailType;
    }

    public void setFreightMailType(Integer freightMailType) {
        this.freightMailType = freightMailType;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }
    public Integer getShopFreightType() {
        return shopFreightType;
    }

    public void setShopFreightType(Integer shopFreightType) {
        this.shopFreightType = shopFreightType;
    }

    public List<ShopDirFreightDto> getShopDirFreightDtoList() {
        return shopDirFreightDtoList;
    }

    public Integer getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }

    public Integer getItemSyncSwitch() {
        return itemSyncSwitch;
    }

    public void setItemSyncSwitch(Integer itemSyncSwitch) {
        this.itemSyncSwitch = itemSyncSwitch;
    }
    public void setShopDirFreightDtoList(List<ShopDirFreightDto> shopDirFreightDtoList) {
        this.shopDirFreightDtoList = shopDirFreightDtoList;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public void setShopWarehouseIds(List<Long> shopWarehouseIds) {
        this.shopWarehouseIds = shopWarehouseIds;
    }

    public List<Long> getShopWarehouseIds() {
        return shopWarehouseIds;
    }

    public String getSellerCode() {
        return sellerCode;
    }

    public void setSellerCode(String sellerCode) {
        this.sellerCode = sellerCode;
    }
}
