package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @author yan.haidong
 * @since 1.0.0
 */
@ApiModel(value = "ShopEsDto", description = "商品店铺")
public class ShopEsDto implements Serializable {

	@ApiModelProperty(name = "shopId", value = "店铺id")
	private Long shopId;

	@ApiModelProperty(name = "shopName", value = "店铺名字")
	private String shopName;

	@ApiModelProperty(name = "status", value = "状态")
	private String status;

	@ApiModelProperty(name = "address", value = "店铺退货地址")
	private String address;

	@ApiModelProperty(name = "shopAddress", value = "店铺实际地址")
	private String shopAddress;

	@ApiModelProperty(name = "geo", value = "经纬度")
	private String geo;

	/**
	 * 店铺类型：1 线上业务, 2 O2O业务
	 */
	@ApiModelProperty(name = "type", value = "店铺类型：1 线上业务, 2 O2O业务")
	private Long type;

	/**
	 * 业务类型：业务类型: 1 快递 , 2 020（同城配送、自提）
	 */
	@ApiModelProperty(name = "businessType", value = "业务类型: 1 快递 , 2 020")
	private Integer businessType;

	/**
	 * 运营类型：1-直营；2- 加盟
	 */
	@ApiModelProperty(name = "manageType", value = "运营类型：1-直营；2- 加盟")
	private Integer manageType;

	/**
	 * 店铺支持的物流方式
	 */
	@ApiModelProperty(name = "deliveryType", value = "店铺支持的物流方式")
	private String deliveryType;

	@ApiModelProperty(name = "cityDelivery", value = "是否开启同城配送")
	private Boolean cityDelivery;

	@ApiModelProperty(name = "selfPickUp", value = "是否开启自提")
	private Boolean selfPickUp;

	/**
	 * 地址坐标：x，y
	 */
	@ApiModelProperty(name = "location", value = "地址坐标")
	private List<LocationDto>   location;

	@ApiModelProperty(name = "templateRegionList", value = "模板区域list")
	private List<TemplateRegionRespDto>  templateRegionList;

	@ApiModelProperty(name = "contactPhone", value = "联系电话")
	private String contactPhone;

	public Long getShopId() {
		return shopId;
	}
	public void setShopId(Long shopId) {
		this.shopId = shopId;
	}

	public String getShopName() {
		return shopName;
	}

	public void setShopName(String shopName) {
		this.shopName = shopName;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Integer getBusinessType() {
		return businessType;
	}
	public void setBusinessType(Integer businessType) {
		this.businessType = businessType;
	}
	public List<LocationDto> getLocation() {
		return location;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getGeo() {
		return geo;
	}

	public void setGeo(String geo) {
		this.geo = geo;
	}

	public Long getType() {
		return type;
	}

	public void setType(Long type) {
		this.type = type;
	}

	public Integer getManageType() {
		return manageType;
	}

	public void setManageType(Integer manageType) {
		this.manageType = manageType;
	}

	public String getDeliveryType() {
		return deliveryType;
	}

	public void setDeliveryType(String deliveryType) {
		this.deliveryType = deliveryType;
	}

	public Boolean getCityDelivery() {
		return cityDelivery;
	}

	public void setCityDelivery(Boolean cityDelivery) {
		this.cityDelivery = cityDelivery;
	}

	public Boolean getSelfPickUp() {
		return selfPickUp;
	}

	public void setSelfPickUp(Boolean selfPickUp) {
		this.selfPickUp = selfPickUp;
	}

	public void setLocation(List<LocationDto> location) {
		this.location = location;
	}
	public List<TemplateRegionRespDto> getTemplateRegionList() {
		return templateRegionList;
	}
	public void setTemplateRegionList(List<TemplateRegionRespDto> templateRegionList) {
		this.templateRegionList = templateRegionList;
	}

	public String getContactPhone() {
		return contactPhone;
	}

	public void setContactPhone(String contactPhone) {
		this.contactPhone = contactPhone;
	}

	public String getShopAddress() {
		return shopAddress;
	}

	public void setShopAddress(String shopAddress) {
		this.shopAddress = shopAddress;
	}
}