

package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 店铺中心透传至会员中心的DTO
 * <p>
 * 用于会员等级定义新增、查询等接口的数据传输对象
 * </p>
 *
 * @author luo.lei
 * @since 1.0.0
 */
@ApiModel(value = "ShopMemberLevelDefineReqDto", description = "会员等级")
public class ShopMemberLevelDefineReqDto extends BaseVo {

    /**
     * 会员等级定义名称
     */
    @ApiModelProperty(name = "name", value = "会员等级定义名称，必填")
    private String name;

    /**
     * 最小成长值
     */
    @ApiModelProperty(name = "minGrowthValue", value = "最小成长值，必填")
    private Integer minGrowthValue;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注，选填")
    private String remark;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMinGrowthValue() {
        return minGrowthValue;
    }

    public void setMinGrowthValue(Integer minGrowthValue) {
        this.minGrowthValue = minGrowthValue;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }


}
