/**
 * @(#)MemberDto.java1.0 2018年7月12日 Copyright (c) 2018, YUNXI. All rights reserved. YUNXI
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 店铺中心透传至会员中心的DTO
 * <p>
 * 用于会员注册、查询等接口的数据传输对象
 * </p>
 *
 * @author luo.lei
 * @since 1.0.0
 */
@ApiModel(value = "ShopMemberReqDto", description = "会员")
public class ShopMemberReqDto extends BaseVo {

    private static final long serialVersionUID = 1361752469102441762L;

    /**
     * 会员Id
     */
    @ApiModelProperty(name = "id", value = "会员Id，选填")
    private Long id;

    /**
     * 会员体系
     */
    @ApiModelProperty(name = "modelId", value = "会员体系，选填")
    private Long modelId;

    /**
     * 会员等级Id
     */
    @ApiModelProperty(name = "memberLevelDefineId", value = "会员等级Id，选填")
    private Long memberLevelDefineId;

    /**
     * 等级名称
     */
    @ApiModelProperty(name = "levelName", value = "等级名称，选填")
    private String levelName;

    /**
     * 应用实例Id
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例Id，必填")
    private Long instanceId;

    /**
     * 用户Id
     */
    @ApiModelProperty(name = "userId", value = "用户Id，必填")
    private Long userId;

    /**
     * 会员名
     */
    @ApiModelProperty(name = "name", value = "会员名，选填")
    private String name;

    /**
     * 会员状态
     */
    @ApiModelProperty(name = "status", value = "会员状态，1：启用 2：禁用，选填，默认启用")
    private Integer status;

    /**
     * 成长值
     */
    @ApiModelProperty(name = "growthValue", value = "成长值，选填，默认0")
    private Integer growthValue;

    /**
     * 激活时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(name = "activateTime", value = "激活时间，选填")
    private Date activateTime;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(name = "createTime", value = "创建时间，选填")
    private Date createTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getModelId() {
        return modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getMemberLevelDefineId() {
        return memberLevelDefineId;
    }

    public void setMemberLevelDefineId(Long memberLevelDefineId) {
        this.memberLevelDefineId = memberLevelDefineId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getGrowthValue() {
        return growthValue;
    }

    public void setGrowthValue(Integer growthValue) {
        this.growthValue = growthValue;
    }

    public String getLevelName() {
        return levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public Date getActivateTime() {
        return activateTime;
    }

    public void setActivateTime(Date activateTime) {
        this.activateTime = activateTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

}
