package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @author luo.lei
 * @since 2.0.0
 */
public class ShopQueryDto extends BaseVo{

    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    @ApiModelProperty(name = "name", value = "店铺名称，支持模糊查询，需要自己拼%")
    private String name;

    @ApiModelProperty(name = "code", value = "店铺编码")
    private String code;

    @NotEmpty(message = "店铺编码列表不能为空")
    @ApiModelProperty(name = "codes", value = "店铺编码列表")
    private List<String> codes;

    @ApiModelProperty(name = "type", value = "店铺类型")
    private Long type;

    @ApiModelProperty(name = "manageType", value = "运营类型：1-直营；2- 加盟")
    private Integer manageType;

    @ApiModelProperty(name = "level", value = "店铺等级")
    private Integer level;

    @ApiModelProperty(name = "status", value = "店铺状态")
    private String status;

    @ApiModelProperty(name = "channelCode", value = "所属渠道code")
    private String channelCode;

    @ApiModelProperty(name = "authStatus", value = "店铺授权状态，0：未授权（默认）；1：授权")
    private Integer authStatus;

    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;

    @ApiModelProperty(name = "isWxacodeDownload", value = "店铺是否已经下载过小程序码：1是，0否")
    private Integer isWxacodeDownload;

    @ApiModelProperty(name = "updatePerson", value = "修改人")
    private String updatePerson;

    @ApiModelProperty(name = "updateTimeStart", value = "更新开始日期 yyyy-MM-dd HH:mm:ss")
    private String updateTimeStart;

    @ApiModelProperty(name = "updateTimeEnd", value = "更新结束日期 yyyy-MM-dd HH:mm:ss")
    private String updateTimeEnd;

    @ApiModelProperty(name = "provinceCode", value = "省编码")
    private String provinceCode;

    @ApiModelProperty(name = "cityCode", value = "市编码")
    private String cityCode;

    @ApiModelProperty(name = "regionCode", value = "区编码")
    private String regionCode;

    public Integer getIsWxacodeDownload() {
        return isWxacodeDownload;
    }

    public void setIsWxacodeDownload(Integer isWxacodeDownload) {
        this.isWxacodeDownload = isWxacodeDownload;
    }

    @ApiModelProperty(name = "id", value = "店铺id, 修改店铺时必传")
    private Long id;

    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    @ApiModelProperty(name = "organizationIds", value = "组织id-List")
    private List<Long> organizationIdList;


    @ApiModelProperty(name = "sellerIdList", value = "商户ID-List")
    private List<Long> sellerIdList;

    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    @ApiModelProperty(name = "contactPhone", value = "联系电话", hidden = true)
    private String contactPhone;

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getType() {
        return type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    @AssertTrue(message = "商户、实例、租户不可同时为NULL")
    @JsonIgnore
    public boolean isLegal() {
        if (null == sellerId  && null == tenantId && null == instanceId) {
            return false;
        }
        return true;
    }

    public Integer getManageType() {
        return manageType;
    }

    public void setManageType(Integer manageType) {
        this.manageType = manageType;
    }

    public String getUpdateTimeStart() {
        return updateTimeStart;
    }

    public void setUpdateTimeStart(String updateTimeStart) {
        this.updateTimeStart = updateTimeStart;
    }

    public String getUpdateTimeEnd() {
        return updateTimeEnd;
    }

    public void setUpdateTimeEnd(String updateTimeEnd) {
        this.updateTimeEnd = updateTimeEnd;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public Integer getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }

    public List<String> getCodes() {
        return codes;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public List<Long> getSellerIdList() {
        return sellerIdList;
    }

    public void setSellerIdList(List<Long> sellerIdList) {
        this.sellerIdList = sellerIdList;
    }

    public List<Long> getOrganizationIdList() {
        return organizationIdList;
    }

    public void setOrganizationIdList(List<Long> organizationIdList) {
        this.organizationIdList = organizationIdList;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }
}
