/*
 * @(#)ShopQueryReqDto.java 1.0 2020-09-28
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 店铺查询DTO
 *
 * @author xiong.jian
 * @version 1.0.0
 */
@ApiModel(value = "ShopQueryReqDto", description = "店铺查询DTO")
public class ShopQueryReqDto extends BaseVo {

    /**
     * 编码
     */
    @NotEmpty(message = "编码不能为空")
    @ApiModelProperty(name = "codes", value = "编码")
    private List<String> codes;

    public List<String> getCodes() {
        return codes;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }
}
