/*
 * *
 *  * @(#)ShopReqDto.java 2.0.0 18-11-6 下午2:39
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 店铺基本信息Dto
 *
 * @author 风信
 * @since 1.0.0
 */
@ApiModel(value = "ShopReqDto", description = "店铺信息Dto")
public class ShopReqDto extends BaseVo {


    private static final long serialVersionUID = 8560136883219794001L;
    private Long id ;

    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID，必填")
    @NotNull(message = "商户ID不允许为空")
    private Long sellerId;

    @ApiModelProperty(name = "commanderInfoId", value = "分销员id")
    private Long commanderInfoId;

    /**
     * 店铺编码
     */
    @ApiModelProperty(name = "code", value = "店铺编码，选填")
    private String code;

    /**
     * 店铺名称
     */
    @ApiModelProperty(name = "name", value = "店铺名称，必填")
    @NotNull(message = "名称不允许为空")
    private String name;

    /**
     * 店铺类型:专营，自营，旗舰,下线门店等(取自基础数据中心)
     */
    @ApiModelProperty(name = "type", value = "店铺类型:专营，自营，旗舰,下线门店等(取自基础数据中心)")
    private Long type;

    /**
     * 运营类型：1-直营；2-加盟
     */
    @ApiModelProperty(name = "manageType", value = "运营类型：1-直营；2-加盟 ")
    private Integer manageType;

    /**
     * 营业形态：暂无（给项目组使用，由项目组确定）
     */
    @ApiModelProperty(name = "businessForm", value = "营业形态：暂无（给项目组使用，由项目组确定）")
    private Integer businessForm;

    /**
     * 店铺等级
     */
    @ApiModelProperty(name = "level", value = "店铺等级，必填")
    @NotNull(message = "店铺等级不允许为空")
    private Integer level;

    /**
     * 联系人
     */
    @ApiModelProperty(name = "contactPerson", value = "联系人，选填")
    private String contactPerson;

    /**
     * 联系电话
     */
    @ApiModelProperty(name = "contactPhone", value = "联系电话，选填")
    private String contactPhone;

    /**
     * url地址
     */
    @ApiModelProperty(name = "shopUrl", value = "url地址，必填")
    @NotNull(message = "url地址不允许为空")
    private String shopUrl;

    /**
     * 状态：NORMAL正常 BANNED封禁 CORRECTION整改
     */
    @ApiModelProperty(name = "status", value = "状态：NORMAL正常 BANNED封禁 CORRECTION整改，必填")
    @NotNull(message = "状态不允许为空")
    private String status;

    /**
     * 地址
     */
    @ApiModelProperty(name = "address", value = "地址，选填")
    private String address;

    /**
     * 省份编码
     */
    @ApiModelProperty(name = "provinceCode", value = "省份编码，选填")
    private String provinceCode;

    /**
     * 地市编码
     */
    @ApiModelProperty(name = "cityCode", value = "地市编码，选填")
    private String cityCode;

    /**
     * 区编码
     */
    @ApiModelProperty(name = "countyCode", value = "区编码，选填")
    private String countyCode;

    @ApiModelProperty(name = "streetCode" , value = "街道编码，选填")
    private String streetCode;


    /**
     * 地址坐标：x，y
     */
    @ApiModelProperty(name = "geo", value = "地址坐标：x，y，选填")
    private String geo;

    /**
     * 店铺简介
     */
    @ApiModelProperty(name = "shopIntroduction", value = "店铺简介，选填")
    private String shopIntroduction;

    /**
     * 店铺logo
     */
    @ApiModelProperty(name = "logo", value = "店铺logo，选填")
    private String logo;

    /**
     * 店铺支持的物流方式
     */
    @ApiModelProperty(name = "deliveryType", value = "店铺支持的物流方式，选填")
    private String deliveryType;

    /**
     * 工作时间
     */
    @ApiModelProperty(name = "workTime", value = "工作时间，选填")
    private String workTime;

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "selfId", value = "店铺ID")
    private Long selfId;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     * 实例ID

     */
    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;

     /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json")
    private String extension ;

    /**
     * 所属人ID
     */
    @ApiModelProperty(name = "owner", value = "所属人ID")
    private Long owner ;

    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId ;

    @ApiModelProperty(name = "isWxacodeDownload", value = "店铺是否已经下载过小程序码：1是，0否")
    private Integer isWxacodeDownload;

    @ApiModelProperty(name = "idCard", value = "身份证号码")
    private String idCard;

    public Integer getIsWxacodeDownload() {
        return isWxacodeDownload;
    }

    public void setIsWxacodeDownload(Integer isWxacodeDownload) {
        this.isWxacodeDownload = isWxacodeDownload;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getType() {
        return type;
    }

    public void setType(Long tpye) {
        this.type = tpye;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getShopUrl() {
        return shopUrl;
    }

    public void setShopUrl(String shopUrl) {
        this.shopUrl = shopUrl;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public String getShopIntroduction() {
        return shopIntroduction;
    }

    public void setShopIntroduction(String shopIntroduction) {
        this.shopIntroduction = shopIntroduction;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(String deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getWorkTime() {
        return workTime;
    }

    public void setWorkTime(String workTime) {
        this.workTime = workTime;
    }

    public Long getSelfId() {
        return selfId;
    }

    public void setSelfId(Long selfId) {
        this.selfId = selfId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getOwner() {
        return owner;
    }

    public void setOwner(Long owner) {
        this.owner = owner;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Integer getManageType() {
        return manageType;
    }

    public void setManageType(Integer manageType) {
        this.manageType = manageType;
    }

    public Integer getBusinessForm() {
        return businessForm;
    }

    public void setBusinessForm(Integer businessForm) {
        this.businessForm = businessForm;
    }

    public Long getCommanderInfoId() {
        return commanderInfoId;
    }

    public void setCommanderInfoId(Long commanderInfoId) {
        this.commanderInfoId = commanderInfoId;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
}
