package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "ShopTransportPartnerDto", description = "店铺配送方信息")
public class ShopTransportPartnerDto extends BaseVo {

    /**
     * 配送方code
     */
    @ApiModelProperty(name = "partnerCode", value = "配送方code:0 商家自配送, 1 达达配送, 2 蜂鸟配送, 3 美团配送")
    private Integer partnerCode;

    /**
     * 配送方name
     */
    @ApiModelProperty(name = "partnerName", value = "配送方name")
    private String partnerName;

    /**
     * 配送方商户编码
     */
    @ApiModelProperty(name = "pMerchantNo", value = "商家在第三方的商户编号")
    private String pMerchantNo;

    /**
     * 配送方门店编码
     */
    @ApiModelProperty(name = "pShopNo", value = "商家门店在第三方的门店编号")
    private String pShopNo;


    public Integer getPartnerCode() {
        return partnerCode;
    }

    public void setPartnerCode(Integer partnerCode) {
        this.partnerCode = partnerCode;
    }

    public String getPartnerName() {
        return partnerName;
    }

    public void setPartnerName(String partnerName) {
        this.partnerName = partnerName;
    }

    public String getpMerchantNo() {
        return pMerchantNo;
    }

    public void setpMerchantNo(String pMerchantNo) {
        this.pMerchantNo = pMerchantNo;
    }

    public String getpShopNo() {
        return pShopNo;
    }

    public void setpShopNo(String pShopNo) {
        this.pShopNo = pShopNo;
    }
}
