/**
 * @(#)ShopWarehouseDto.java 1.0 2018/9/3
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import javax.validation.constraints.NotNull;

import com.dtyunxi.vo.BaseVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 店铺绑定的仓库Dto
 *
 * @author 风信
 * @since 1.0.0
 */
@ApiModel(value = "ShopWarehouseDto", description = "店铺绑定的仓库Dto")
public class ShopWarehouseDto extends BaseVo {
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID，必填")
    @NotNull(message = "店铺ID不允许为空")
    private Long shopId;

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID", required = true)
    @NotNull(message = "仓库ID不允许为空")
    private Long warehouseId;

    @ApiModelProperty(name = "warehouseId", value = "仓库code", required = true)
    @NotNull(message = "仓库code不能为空")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseId", value = "仓库名称", required = true)
    @NotNull(message = "仓库ID不允许为空")
    private String warehouseName;

    @ApiModelProperty(name = "geo", value = "(仓库配送类型为同城配送)应的电子围栏坐标")
    private String geo;

    @ApiModelProperty(name = "areaDtoList", value = "(仓库配送类型为快递)对应的配送区域范围")
    private List<AreaDto> areaDtoList;

    @ApiModelProperty(name = "type", value = "仓库类型")
    private String type;

    @ApiModelProperty(name = "status", value = "仓库状态")
    private String status;

    @ApiModelProperty(name = "addr", value = "仓库地址")
    private String addr;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;


    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId ;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }


    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public List<AreaDto> getAreaDtoList() {
        return areaDtoList;
    }

    public void setAreaDtoList(List<AreaDto> areaDtoList) {
        this.areaDtoList = areaDtoList;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAddr() {
        return addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }
}
