/*
 * @(#)SubStationQueryDto.java 1.0 2020-06-01
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 区域子站查询实体
 * @author 东海
 * @since 2.0.0
 */
@ApiModel(value = "SubStationQueryDto", description = "区域子站查询实体")
public class SubStationQueryDto extends BaseVo{
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;

    /**
     * 编码
     */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;

    /**
     * 类型
     */
    @ApiModelProperty(name = "type", value = "类型")
    private String type;

    /**
     * 状态(0启用 ， 1 禁用)
     */
    @ApiModelProperty(name = "status", value = "状态(0启用 ， 1 禁用)")
    private Integer status;

    /**
     * 地址
     */
    @ApiModelProperty(name = "address", value = "地址")
    private String address;

    /**
     * 省份编码
     */
    @ApiModelProperty(name = "provinceCode", value = "省份编码")
    private String provinceCode;

    /**
     * 地市编码
     */
    @ApiModelProperty(name = "cityCode", value = "地市编码")
    private String cityCode;

    /**
     * 区编码
     */
    @ApiModelProperty(name = "countyCode", value = "区编码")
    private String countyCode;

    /**
     * 街道编码
     */
    @ApiModelProperty(name = "streetCode", value = "街道编码")
    private String streetCode;

    /**
     * 地理坐标。x，y
     */
    @ApiModelProperty(name = "geo", value = "地理坐标。x，y")
    private String geo;

    /**
     * 简介
     */
    @ApiModelProperty(name = "shopIntroduction", value = "简介")
    private String shopIntroduction;

    /**
     * 头像logo
     */
    @ApiModelProperty(name = "logo", value = "头像logo")
    private String logo;


    /**
     * 租户id
     */
    @ApiModelProperty(name = "tenantId", value = "租户id")
    private Long tenantId;

    /**
     * 应用实例id
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例id")
    private Long instanceId;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(name = "updateTime", value = "修改时间")
    private Date updateTime;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    /**
     * 修改人
     */
    @ApiModelProperty(name = "updatePerson", value = "修改人")
    private String updatePerson;

    /**
     * 逻辑删除标志，0表示未删除，1表示删除
     */
    @ApiModelProperty(name = "dr", value = "逻辑删除标志")
    private boolean dr;

    /**
     * 所属人id
     */
    @ApiModelProperty(name = "ownerId", value = "所属人id")
    private Long ownerId;

    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json，选填")
    private String extension;

    public Long getId() {
        return id;
    }
    public void setId(Long id) {
        this.id = id;
    }
    public String getCode() {
        return code;
    }
    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public String getType() {
        return type;
    }
    public void setType(String type) {
        this.type = type;
    }
    public Integer getStatus() {
        return status;
    }
    public void setStatus(Integer status) {
        this.status = status;
    }
    public String getAddress() {
        return address;
    }
    public void setAddress(String address) {
        this.address = address;
    }
    public String getProvinceCode() {
        return provinceCode;
    }
    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }
    public String getCityCode() {
        return cityCode;
    }
    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }
    public String getCountyCode() {
        return countyCode;
    }
    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }
    public String getStreetCode() {
        return streetCode;
    }
    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }
    public String getGeo() {
        return geo;
    }
    public void setGeo(String geo) {
        this.geo = geo;
    }
    public String getShopIntroduction() {
        return shopIntroduction;
    }
    public void setShopIntroduction(String shopIntroduction) {
        this.shopIntroduction = shopIntroduction;
    }
    public String getLogo() {
        return logo;
    }
    public void setLogo(String logo) {
        this.logo = logo;
    }
    public Long getTenantId() {
        return tenantId;
    }
    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
    public Long getInstanceId() {
        return instanceId;
    }
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
    public Date getCreateTime() {
        return createTime;
    }
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
    public Date getUpdateTime() {
        return updateTime;
    }
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
    public String getCreatePerson() {
        return createPerson;
    }
    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }
    public String getUpdatePerson() {
        return updatePerson;
    }
    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }
    public boolean isDr() {
        return dr;
    }
    public void setDr(boolean dr) {
        this.dr = dr;
    }
    public Long getOwnerId() {
        return ownerId;
    }
    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }
    public String getExtension() {
        return extension;
    }
    public void setExtension(String extension) {
        this.extension = extension;
    }
}
