package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 模板区域Dto
 *
 * @author 东海
 * @since 2.0.0
 */
@ApiModel(value = "TemplateRegionRespDto", description = "模板区域")
public class TemplateRegionRespDto {

	@ApiModelProperty(name = "warehouseId", value = "仓库ID")
	private Long warehouseId;

	@ApiModelProperty(name = "polygon", value = "多边形")
	private String  type = "polygon";

	private  List<List<List<Double>>> coordinates;

	public TemplateRegionRespDto() {
	}

	public TemplateRegionRespDto(List<List<List<Double>>> coordinates) {
		this.warehouseId = 0L;
		this.type = "polygon";
		this.coordinates = coordinates;
	}

	public Long getWarehouseId() {
		return warehouseId;
	}
	public void setWarehouseId(Long warehouseId) {
		this.warehouseId = warehouseId;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public List<List<List<Double>>> getCoordinates() {
		return coordinates;
	}
	public void setCoordinates(List<List<List<Double>>> coordinates) {
		this.coordinates = coordinates;
	}
}