/*
 * @(#)CountFreightRuleReqDto.java 1.0 2021-03-02
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreightTemplateRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 计算运费规则
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "CountFreightRuleReqDto", description = "计算运费规则")
public class CountFreightRuleReqDto extends BaseVo {
    @ApiModelProperty(name = "freightTemplate", value = "运费模板信息")
    private FreightTemplateRespDto freightTemplate;
    @ApiModelProperty(name = "shop", value = "关联店铺信息 ")
    private ShopDto shop;

    public ShopDto getShop() {
        return shop;
    }

    public void setShop(ShopDto shop) {
        this.shop = shop;
    }

    public FreightTemplateRespDto getFreightTemplate() {
        return freightTemplate;
    }

    public void setFreightTemplate(FreightTemplateRespDto freightTemplate) {
        this.freightTemplate = freightTemplate;
    }
}