/*
 * @(#)DistanceFreightCountReqDto.java 1.0 2020-07-15
 *
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "DistanceFreightCountReqDto", description = "距离运费计算")
public class DistanceFreightCountReqDto {
    @ApiModelProperty(name = "originLat", value = "来源纬度")
    private String originLat;
    @ApiModelProperty(name = "originLon", value = "来源经度")
    private String originLon;
    @ApiModelProperty(name = "destinationLon", value = "目的地经度")
    private String destinationLon;
    @ApiModelProperty(name = "destinationLat", value = "目的地维度")
    private String destinationLat;
    @ApiModelProperty(name = "distance", value = "距离")
    private Double distance;
    @ApiModelProperty(name = "baseFreight", value = "起始费用")
    private BigDecimal baseFreight;
    @ApiModelProperty(name = "baseDistance", value = "起始距离")
    private Double baseDistance;
    @ApiModelProperty(name = "increaseFreight", value = "增长费用")
    private BigDecimal increaseFreight;
    @ApiModelProperty(name = "increaseDistance", value = "增长距离")
    private Double increaseDistance;

    public Double getDistance() {
        return distance;
    }

    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public String getOriginLat() {
        return originLat;
    }

    public void setOriginLat(String originLat) {
        this.originLat = originLat;
    }

    public String getOriginLon() {
        return originLon;
    }

    public void setOriginLon(String originLon) {
        this.originLon = originLon;
    }

    public String getDestinationLon() {
        return destinationLon;
    }

    public void setDestinationLon(String destinationLon) {
        this.destinationLon = destinationLon;
    }

    public String getDestinationLat() {
        return destinationLat;
    }

    public void setDestinationLat(String destinationLat) {
        this.destinationLat = destinationLat;
    }

    public BigDecimal getBaseFreight() {
        return baseFreight;
    }

    public void setBaseFreight(BigDecimal baseFreight) {
        this.baseFreight = baseFreight;
    }

    public Double getBaseDistance() {
        return baseDistance;
    }

    public void setBaseDistance(Double baseDistance) {
        this.baseDistance = baseDistance;
    }

    public BigDecimal getIncreaseFreight() {
        return increaseFreight;
    }

    public void setIncreaseFreight(BigDecimal increaseFreight) {
        this.increaseFreight = increaseFreight;
    }

    public Double getIncreaseDistance() {
        return increaseDistance;
    }

    public void setIncreaseDistance(Double increaseDistance) {
        this.increaseDistance = increaseDistance;
    }
}