package com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight;

import com.dtyunxi.yundt.cube.center.shop.api.dto.request.DeliveryAreaDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 免运费规则
 *
 * @author 本参
 * @since 3.14.1.0
 */
@ApiModel(value = "FreeFreightRuleReqDto", description = "免运费规则")
public class FreeFreightRuleReqDto extends RuleAreaBase {

    private Long freightTemplateId;

    /**
     * 满多少元/件/米/km
     */
    @ApiModelProperty(name = "fullValue", value = "满多少元/件/米/km")
    private BigDecimal fullValue = BigDecimal.ZERO;

    /**
     * 单位：0元 1件 2距离
     */
    @NotNull(message = "免邮单位为必填项 元/件/距离")
    @ApiModelProperty(name = "fullValue", value = "单位：0元 1件 2距离")
    private Byte unit;


    public BigDecimal getFullValue() {
        return fullValue;
    }

    public void setFullValue(BigDecimal fullValue) {
        this.fullValue = fullValue;
    }

    public Byte getUnit() {
        return unit;
    }

    public void setUnit(Byte unit) {
        this.unit = unit;
    }


    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }
}
