package com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight;

import com.dtyunxi.yundt.cube.center.shop.api.dto.request.DeliveryAreaDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.bouncycastle.cms.PasswordRecipient;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 运费规则
 *
 * @author 本参
 * @since 3.14.1.0
 */
@ApiModel(value = "FreightRuleReqDto", description = "运费规则")
public class FreightRuleReqDto extends RuleAreaBase {
    /**
     * 模板ID 不需要前端赋值
     */
    private Long freightTemplateId;
    /**
     * 起始 重量/件数/体积/距离
     */
    @ApiModelProperty(name = "firstValue", value = "起始 重量/件数/体积/距离")
//    @NotNull(message = "起始 【重量/件数/体积/距离】必填项")
//    @Min(value = 0, message = "起始 【重量/件数/体积/距离】必须大于或等于0")
//    @Max(value = 99999999, message = "起始 【重量/件数/体积/距离】不能大于99999999.99")
    private BigDecimal firstValue;

    /**
     * 起始价格
     */
    @ApiModelProperty(name = "firstFreight", value = "起始价格")
//    @NotNull(message = "起始价格不能为空")
//    @Min(value = 0, message = "起始价格必须大于或等于0")
//    @Max(value = 99999999, message = "起始价格不能大于99999999.99")
    private BigDecimal firstFreight;

    /**
     * 每超出 重量/件数/体积/距离/金额
     */
//    @ApiModelProperty(name = "continueValue", value = "每超出 重量/件数/体积/距离/金额")
//    @NotNull(message = "每超出 重量/件数/体积/距离/金额 不能为空")
//    @Min(value = 0, message = "每超出 重量/件数/体积/距离/金额大于或等于0")
//    @Max(value = 99999999, message = "每超出 重量/件数/体积/距离/金额不能大于99999999.99")
    private BigDecimal continueValue;

    /**
     * 每超出 价格
     */
//    @ApiModelProperty(name = "continueFreight", value = "每超出 价格")
//    @NotNull(message = "每超出 价格 不能为空")
//    @Min(value = 0, message = "每超出价格必须大于或等于0")
//    @Max(value = 99999999, message = "每超出价格不能大于99999999.99")
    private BigDecimal continueFreight;

    /**
     * 固定运费
     */
//    @ApiModelProperty(name = "fixedCost", value = "固定运费")
    private BigDecimal fixedCost = BigDecimal.ZERO;


    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public BigDecimal getFirstValue() {
        return firstValue;
    }

    public void setFirstValue(BigDecimal firstValue) {
        this.firstValue = firstValue;
    }

    public BigDecimal getFirstFreight() {
        return firstFreight;
    }

    public void setFirstFreight(BigDecimal firstFreight) {
        this.firstFreight = firstFreight;
    }

    public BigDecimal getContinueValue() {
        return continueValue;
    }

    public void setContinueValue(BigDecimal continueValue) {
        this.continueValue = continueValue;
    }

    public BigDecimal getContinueFreight() {
        return continueFreight;
    }

    public void setContinueFreight(BigDecimal continueFreight) {
        this.continueFreight = continueFreight;
    }

    public BigDecimal getFixedCost() {
        return fixedCost;
    }

    public void setFixedCost(BigDecimal fixedCost) {
        this.fixedCost = fixedCost;
    }


}
