package com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 分页查询运费模板参数
 *
 * @author 本参
 * @since 3.14.1.0
 */
@ApiModel(value = "FreightTemplatePageReqDto", description = "分页查询运费模板参数")
public class FreightTemplatePageReqDto {
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页大小")
    private Integer pageSize;
    @ApiModelProperty(name = "code", value = "模板编码 模糊查询")
    private String code;
    @ApiModelProperty(name = "name", value = "模板名称 模糊查询")
    private String name;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "updateTimeStart", value = "更新时间起点")
    private Date updateTimeStart;
    @ApiModelProperty(name = "updateTimeEnd", value = "更新时间终点")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTimeEnd;
    @ApiModelProperty(name = "state", value = "0 禁用 1启用 null或不传该字段查所有")
    private Byte state;
    @ApiModelProperty(name = "type", value = "0或者null所有 1只适用商品")
    private Byte type = 0;

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getUpdateTimeStart() {
        return updateTimeStart;
    }

    public void setUpdateTimeStart(Date updateTimeStart) {
        this.updateTimeStart = updateTimeStart;
    }

    public Date getUpdateTimeEnd() {
        return updateTimeEnd;
    }

    public void setUpdateTimeEnd(Date updateTimeEnd) {
        this.updateTimeEnd = updateTimeEnd;
    }

    public Byte getState() {
        return state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }
}
