package com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.util.List;

/**
 * 运费模板
 *
 * @author 本参
 * @since 3.14.1.0
 */
@ApiModel(value = "FreightTemplateReqDto", description = "运费模板")
public class FreightTemplateReqDto {

    /**
     * 模板ID
     */
    @ApiModelProperty(name = "id", value = "模板ID，新增时候该字段不需要赋值 修改需要赋值")
    private Long id;

    /**
     * 运费模板编号
     */
    @NotEmpty(message = "运费模板编号不能为空")
    @ApiModelProperty(name = "code", value = "运费模板编号")
    @Size(max = 32, message = "运费模板编号不能为空的长度不能超过32")
    private String code;

    /**
     * 运费模板名称
     */
    @NotEmpty(message = "运费模板名称不能为空")
    @ApiModelProperty(name = "name", value = "运费模板名称")
    @Size(max = 64, message = "运费模板名称不能为空的长度不能超过64")
    private String name;

    /**
     * 起送价格
     * 默认为0
     */
    @ApiModelProperty(name = "startingPric", value = "起送价格 默认为0")
//    @NotNull(message = "起送价格不能为空")
//    @Min(value = 0, message = "起送价不能小于0")
//    @Max(value = 99999999, message = "起送价格不能大于99999999")
    private BigDecimal startingPric = BigDecimal.ZERO;

    /**
     * 计费方式
     * 0 重量；
     * 1 件数；
     * 2 体积；
     * 3 距离；
     * 4 金额【固定运费】
     */
    @NotNull(message = "计费方式不能为空")
    @ApiModelProperty(name = "freightType", value = "计费方式：0 重量；1 件数；2 体积；3 距离；4 金额【固定运费】")
    @Min(value = 0, message = "计费方式不正确")
    @Max(value = 4, message = "计费方式不正确")
    private Byte freightType;

    /**
     * 是否启用免运费规则
     * 0不启用（默认）
     * 1启用
     */
    @ApiModelProperty(name = "freeFreight", value = "是否启用免运费规则 0不启用（默认）1启用")
    @Min(value = 0, message = "是否启用免运费规则不正确")
    @Max(value = 1, message = "是否启用免运费规则不正确")
    private Byte freeFreight = (byte) 0;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    @Size(max = 64, message = "备注不能超过20字长")
    private String remark;

    /**
     * 0 禁用 ；1启用
     */
    @ApiModelProperty(name = "state", value = "0禁用 ；1启用 新增时 该值如果前端不给 默认启用")
    private Byte state;

    /**
     * 运费规则集合
     */
    @ApiModelProperty(name = "freightRuleList", value = "运费规则集合")
    private List<@Valid FreightRuleReqDto> freightRuleList;

    /**
     * 免运费规则集合
     */
    @ApiModelProperty(name = "freeFreightRuleList", value = "免运费规则集合")
    private List<@Valid FreeFreightRuleReqDto> freeFreightRuleList;

    @ApiModelProperty(name = "organizationId", value = "组织ID")
    @NotNull(message = "必须选择一个组织")
    private Long organizationId;

    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getStartingPric() {
        return startingPric;
    }

    public void setStartingPric(BigDecimal startingPric) {
        this.startingPric = startingPric;
    }

    public Byte getFreightType() {
        return freightType;
    }

    public void setFreightType(Byte freightType) {
        this.freightType = freightType;
    }

    public Byte getFreeFreight() {
        return freeFreight;
    }

    public void setFreeFreight(Byte freeFreight) {
        this.freeFreight = freeFreight;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<FreightRuleReqDto> getFreightRuleList() {
        return freightRuleList;
    }

    public void setFreightRuleList(List<FreightRuleReqDto> freightRuleList) {
        this.freightRuleList = freightRuleList;
    }

    public List<FreeFreightRuleReqDto> getFreeFreightRuleList() {
        return freeFreightRuleList;
    }

    public void setFreeFreightRuleList(List<FreeFreightRuleReqDto> freeFreightRuleList) {
        this.freeFreightRuleList = freeFreightRuleList;
    }

    public Byte getState() {
        return state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }
}
