package com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight;

import java.util.List;
import java.util.UUID;

import org.apache.commons.lang3.StringUtils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.DeliveryAreaDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


@ApiModel(value = "RuleAreaBase", description = "规则适用区域信息")
public class RuleAreaBase {

    @ApiModelProperty(name = "deliveryAreaDtoList", value = "规则适用的区域 前端入参")
    private List<DeliveryAreaDto> deliveryAreaDtoList;

    /**
     * 规则适用的区域
     * 多个区域编码采用","隔开
     */
    @ApiModelProperty(name = "areaCode", value = "规则适用的区域,多个区域编码采用\",\"隔开")
    private String areaCode;

    private String ruleCode;

    public RuleAreaBase() {
        this.ruleCode = UUID.randomUUID().toString();
    }

    public List<DeliveryAreaDto> getDeliveryAreaDtoList() {
        return deliveryAreaDtoList;
    }

    public void setDeliveryAreaDtoList(List<DeliveryAreaDto> deliveryAreaDtoList) {
        this.deliveryAreaDtoList = deliveryAreaDtoList;
    }

    public String getAreaCode() {
        if (StringUtils.isBlank(this.areaCode)) {
            list2Text();
        }
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    public void list2Text() {
        if (this.deliveryAreaDtoList == null || this.deliveryAreaDtoList.isEmpty()) {
            throw new BizException("必须选择区域");
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < this.deliveryAreaDtoList.size(); i++) {
            DeliveryAreaDto deliveryAreaDto = this.deliveryAreaDtoList.get(i);
            String code = null;
            if (StringUtils.isNotBlank(deliveryAreaDto.getAreaCode())) {
                code = deliveryAreaDto.getAreaCode();
            } else if (StringUtils.isNotBlank(deliveryAreaDto.getCityCode())) {
                code = deliveryAreaDto.getCityCode();
            } else if (StringUtils.isNotBlank(deliveryAreaDto.getProvCode())) {
                code = deliveryAreaDto.getProvCode();
            }
            if (StringUtils.isBlank(code)) {
                continue;
            }
            text.append(code);
            if (i != this.deliveryAreaDtoList.size() - 1) {
                text.append(",");
            }
        }
        this.areaCode = text.toString();
    }
}
